/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.MetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class MetadataBenchmark
extends MetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(MetadataBenchmark.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl", enabled=false)
    public void testGet(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            int N_KEYS = 128;
            int N_GETS = 1000000;
            String key = this.newKey();
            this.generateKeys(store, key, 128);
            Semaphore s = new Semaphore(10000);
            CountDownLatch latch = new CountDownLatch(1000000);
            long startTime = System.nanoTime();
            for (int i = 0; i < 1000000; ++i) {
                int k = i % 127;
                s.acquire();
                ((CompletableFuture)store.get(key + "/" + k).thenAccept(__ -> {
                    s.release();
                    latch.countDown();
                })).exceptionally(ex -> {
                    log.warn("Failed to do get operation", ex);
                    return null;
                });
            }
            latch.await();
            long endTime = System.nanoTime();
            double throughput = 1.0E15 / (double)(endTime - startTime);
            log.info("[{}] Get Throughput: {} Kops/s", (Object)provider, (Object)(throughput / 1000.0));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(dataProvider="impl", enabled=false)
    public void testGetChildren(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            int N_KEYS = 128;
            int N_GETS = 1000000;
            String key = this.newKey();
            this.generateKeys(store, key, 128);
            Semaphore s = new Semaphore(10000);
            CountDownLatch latch = new CountDownLatch(1000000);
            long startTime = System.nanoTime();
            for (int i = 0; i < 1000000; ++i) {
                s.acquire();
                ((CompletableFuture)store.getChildren(key).thenAccept(__ -> {
                    s.release();
                    latch.countDown();
                })).exceptionally(ex -> {
                    log.warn("Failed to do get children operation", ex);
                    return null;
                });
            }
            latch.await();
            long endTime = System.nanoTime();
            double throughput = 1.0E15 / (double)(endTime - startTime);
            log.info("[{}] Get Children Throughput: {} Kops/s", (Object)provider, (Object)(throughput / 1000.0));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl", enabled=false)
    public void testPut(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            int N_KEYS = 10000;
            int N_PUTS = 100000;
            String key = this.newKey();
            Semaphore s = new Semaphore(10000);
            CountDownLatch latch = new CountDownLatch(100000);
            this.generateKeys(store, key, 10000);
            long startTime = System.nanoTime();
            byte[] data = new byte[100];
            for (int i = 0; i < 100000; ++i) {
                int k = i % 9999;
                s.acquire();
                ((CompletableFuture)store.put(key + "/" + k, data, Optional.empty()).thenAccept(__ -> {
                    s.release();
                    latch.countDown();
                })).exceptionally(ex -> {
                    log.warn("Failed to do put operation", ex);
                    return null;
                });
            }
            latch.await();
            long endTime = System.nanoTime();
            double throughput = 1.0E14 / (double)(endTime - startTime);
            log.info("[{}] Put Throughput: {} Kops/s", (Object)provider, (Object)(throughput / 1000.0));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    private void generateKeys(MetadataStore store, String prefix, int n) {
        byte[] payload = new byte[128];
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (int i = 0; i < n; ++i) {
            futures.add(store.put(prefix + "/" + i, payload, Optional.empty()));
        }
        FutureUtil.waitForAll(futures).join();
    }
}

