/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.TextFormat;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.net.DNS;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarLayoutManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManagerFactory;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class LedgerUnderreplicationManagerTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(LedgerUnderreplicationManagerTest.class);
    private MetadataStoreExtended store;
    private LayoutManager layoutManager;
    private LedgerManagerFactory lmf;
    private LedgerUnderreplicationManager lum;
    private String basePath;
    private String urLedgerPath;
    private ExecutorService executor;

    private Future<Long> getLedgerToReplicate(LedgerUnderreplicationManager m) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                log.info("Starting thread checking for ledgers");
                long l = m.getLedgerToRereplicate();
                log.info("Get ledger id: {}", (Object)Long.toHexString(l));
                return l;
            }
            catch (Exception e) {
                log.error("Error getting ledger id", (Throwable)e);
                return -1L;
            }
        }, this.executor);
    }

    private void methodSetup(Supplier<String> urlSupplier) throws Exception {
        this.executor = Executors.newSingleThreadExecutor();
        String ledgersRoot = "/ledgers-" + UUID.randomUUID();
        this.store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        this.layoutManager = new PulsarLayoutManager(this.store, ledgersRoot);
        this.lmf = new PulsarLedgerManagerFactory();
        ClientConfiguration conf = new ClientConfiguration();
        conf.setZkLedgersRootPath(ledgersRoot);
        this.lmf.initialize((AbstractConfiguration)conf, this.layoutManager, 1);
        this.lum = this.lmf.newLedgerUnderreplicationManager();
        this.basePath = ledgersRoot + '/' + "underreplication";
        this.urLedgerPath = this.basePath + "/ledgers";
    }

    @AfterMethod(alwaysRun=true)
    public final void methodCleanup() throws Exception {
        if (this.lum != null) {
            this.lum.close();
        }
        if (this.lmf != null) {
            this.lmf.close();
        }
        if (this.store != null) {
            this.store.close();
        }
        if (this.executor != null) {
            try {
                this.executor.shutdownNow();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.executor = null;
        }
    }

    @Test(dataProvider="impl")
    public void testBasicInteraction(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        HashSet<Long> ledgers = new HashSet<Long>();
        ledgers.add(3735928559L);
        ledgers.add(3203386110L);
        ledgers.add(0xFFFFBEEFL);
        ledgers.add(4207853295L);
        String missingReplica = "localhost:3181";
        int count = ledgers.size();
        Iterator iterator = ledgers.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            this.lum.markLedgerUnderreplicated(l, missingReplica);
        }
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
        for (int i = 0; i < count; ++i) {
            futures.add(this.getLedgerToReplicate(this.lum));
        }
        for (Future future : futures) {
            Long l = (Long)future.get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)ledgers.remove(l));
        }
        Future<Long> f = this.getLedgerToReplicate(this.lum);
        try {
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Long l = 0xFEFEFEFEFEFEL;
        this.lum.markLedgerUnderreplicated(l.longValue(), missingReplica);
        Assert.assertEquals((String)"Should have got the one just added", (Object)l, (Object)f.get(5L, TimeUnit.SECONDS));
    }

    @Test(dataProvider="impl")
    public void testGetList(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        HashSet<Long> ledgers = new HashSet<Long>();
        ledgers.add(3735928559L);
        ledgers.add(3203386110L);
        ledgers.add(0xFFFFBEEFL);
        ledgers.add(4207853295L);
        String missingReplica = "localhost:3181";
        Iterator iterator = ledgers.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            this.lum.markLedgerUnderreplicated(l, missingReplica);
        }
        HashSet<Long> foundLedgers = new HashSet<Long>();
        Iterator it = this.lum.listLedgersToRereplicate(null);
        while (it.hasNext()) {
            UnderreplicatedLedger ul = (UnderreplicatedLedger)it.next();
            foundLedgers.add(ul.getLedgerId());
        }
        Assert.assertEquals(foundLedgers, ledgers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testLocking(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        String missingReplica = "localhost:3181";
        LedgerUnderreplicationManager m1 = this.lmf.newLedgerUnderreplicationManager();
        LedgerUnderreplicationManager m2 = this.lmf.newLedgerUnderreplicationManager();
        try {
            Long ledger = 1093839814060L;
            m1.markLedgerUnderreplicated(ledger.longValue(), missingReplica);
            Future<Long> f = this.getLedgerToReplicate(m1);
            Long l = f.get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Should be the ledger I just marked", (Object)ledger, (Object)l);
            f = this.getLedgerToReplicate(m2);
            try {
                f.get(1L, TimeUnit.SECONDS);
                Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            m1.close();
            l = f.get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Should be the ledger I marked", (Object)ledger, (Object)l);
        }
        finally {
            if (Collections.singletonList(m2).get(0) != null) {
                m2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testMarkingAsReplicated(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        String missingReplica = "localhost:3181";
        LedgerUnderreplicationManager m1 = this.lmf.newLedgerUnderreplicationManager();
        LedgerUnderreplicationManager m2 = this.lmf.newLedgerUnderreplicationManager();
        try {
            Long ledgerA = 1093839814060L;
            Long ledgerB = 233811435L;
            m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica);
            m1.markLedgerUnderreplicated(ledgerB.longValue(), missingReplica);
            Future<Long> fA = this.getLedgerToReplicate(m1);
            Future<Long> fB = this.getLedgerToReplicate(m1);
            Long lA = fA.get(5L, TimeUnit.SECONDS);
            Long lB = fB.get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((String)"Should be the ledgers I just marked", (lA.equals(ledgerA) && lB.equals(ledgerB) || lA.equals(ledgerB) && lB.equals(ledgerA) ? 1 : 0) != 0);
            Future<Long> f = this.getLedgerToReplicate(m2);
            try {
                f.get(1L, TimeUnit.SECONDS);
                Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            m1.markLedgerReplicated(lA.longValue());
            m1.close();
            Long l = f.get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Should be the ledger I marked", (Object)lB, (Object)l);
        }
        finally {
            if (Collections.singletonList(m2).get(0) != null) {
                m2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testRelease(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        String missingReplica = "localhost:3181";
        LedgerUnderreplicationManager m1 = this.lmf.newLedgerUnderreplicationManager();
        try {
            LedgerUnderreplicationManager m2 = this.lmf.newLedgerUnderreplicationManager();
            try {
                Long ledgerA = 1093839814060L;
                Long ledgerB = 233811435L;
                m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica);
                m1.markLedgerUnderreplicated(ledgerB.longValue(), missingReplica);
                Future<Long> fA = this.getLedgerToReplicate(m1);
                Future<Long> fB = this.getLedgerToReplicate(m1);
                Long lA = fA.get(5L, TimeUnit.SECONDS);
                Long lB = fB.get(5L, TimeUnit.SECONDS);
                Assert.assertTrue((String)"Should be the ledgers I just marked", (lA.equals(ledgerA) && lB.equals(ledgerB) || lA.equals(ledgerB) && lB.equals(ledgerA) ? 1 : 0) != 0);
                Future<Long> f = this.getLedgerToReplicate(m2);
                try {
                    f.get(1L, TimeUnit.SECONDS);
                    Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                m1.markLedgerReplicated(lA.longValue());
                m1.releaseUnderreplicatedLedger(lB.longValue());
                Long l = f.get(5L, TimeUnit.SECONDS);
                Assert.assertEquals((String)"Should be the ledger I marked", (Object)lB, (Object)l);
            }
            finally {
                if (Collections.singletonList(m2).get(0) != null) {
                    m2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(m1).get(0) != null) {
                m1.close();
            }
        }
    }

    @Test(dataProvider="impl")
    public void testManyFailures(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        String missingReplica1 = "localhost:3181";
        String missingReplica2 = "localhost:3182";
        Long ledgerA = 1093839814060L;
        this.lum.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        Future<Long> fA = this.getLedgerToReplicate(this.lum);
        Long lA = fA.get(5L, TimeUnit.SECONDS);
        this.lum.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica2);
        Assert.assertEquals((String)"Should be the ledger I just marked", (Object)lA, (Object)ledgerA);
        this.lum.markLedgerReplicated(lA.longValue());
        Future<Long> f = this.getLedgerToReplicate(this.lum);
        lA = f.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger I had marked previously", (Object)lA, (Object)ledgerA);
    }

    @Test(dataProvider="impl")
    public void testGetReplicationWorkerIdRereplicatingLedger(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        String missingReplica1 = "localhost:3181";
        String missingReplica2 = "localhost:3182";
        Long ledgerA = 1093839814060L;
        this.lum.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        this.lum.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica2);
        Assert.assertEquals((String)"ReplicationWorkerId of the lock", null, (Object)this.lum.getReplicationWorkerIdRereplicatingLedger(ledgerA.longValue()));
        Future<Long> fA = this.getLedgerToReplicate(this.lum);
        Long lA = fA.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger that was just marked", (Object)lA, (Object)ledgerA);
        Assert.assertEquals((String)"ReplicationWorkerId of the lock", (Object)DNS.getDefaultHost((String)"default"), (Object)this.lum.getReplicationWorkerIdRereplicatingLedger(ledgerA.longValue()));
        this.lum.markLedgerReplicated(lA.longValue());
        Assert.assertEquals((String)"ReplicationWorkerId of the lock", null, (Object)this.lum.getReplicationWorkerIdRereplicatingLedger(ledgerA.longValue()));
    }

    @Test(dataProvider="impl")
    public void test2reportSame(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        String missingReplica1 = "localhost:3181";
        LedgerUnderreplicationManager m1 = this.lmf.newLedgerUnderreplicationManager();
        LedgerUnderreplicationManager m2 = this.lmf.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        m2.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        DataFormats.UnderreplicatedLedgerFormat.Builder builderA = DataFormats.UnderreplicatedLedgerFormat.newBuilder();
        byte[] data = ((GetResult)((Optional)this.store.get(this.getUrLedgerZnode(ledgerA)).join()).get()).getValue();
        TextFormat.merge((CharSequence)new String(data, Charset.forName("UTF-8")), (Message.Builder)builderA);
        ProtocolStringList replicaList = builderA.getReplicaList();
        Assert.assertEquals((String)("Published duplicate missing replica : " + replicaList), (long)1L, (long)replicaList.size());
        Assert.assertTrue((String)("Published duplicate missing replica : " + replicaList), (boolean)replicaList.contains(missingReplica1));
        Future<Long> fA = this.getLedgerToReplicate(m1);
        Long lA = fA.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger I just marked", (Object)lA, (Object)ledgerA);
        m1.markLedgerReplicated(lA.longValue());
        Future<Long> f = this.getLedgerToReplicate(m2);
        try {
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test(dataProvider="impl")
    public void testMultipleManagersShouldBeAbleToTakeAndReleaseLock(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        String missingReplica1 = "localhost:3181";
        final LedgerUnderreplicationManager m1 = this.lmf.newLedgerUnderreplicationManager();
        final LedgerUnderreplicationManager m2 = this.lmf.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        int iterationCount = 100;
        final CountDownLatch latch1 = new CountDownLatch(100);
        final CountDownLatch latch2 = new CountDownLatch(100);
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                LedgerUnderreplicationManagerTest.this.takeLedgerAndRelease(m1, latch1, 100);
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                LedgerUnderreplicationManagerTest.this.takeLedgerAndRelease(m2, latch2, 100);
            }
        };
        thread1.start();
        thread2.start();
        while (!latch1.await(50L, TimeUnit.MILLISECONDS) && !latch2.await(50L, TimeUnit.MILLISECONDS)) {
            Thread.sleep(50L);
        }
        m1.close();
        m2.close();
        latch1.await();
        latch2.await();
    }

    @Test(dataProvider="impl")
    public void testMarkSimilarMissingReplica(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        ArrayList<String> missingReplica = new ArrayList<String>();
        missingReplica.add("localhost:3181");
        missingReplica.add("localhost:318");
        missingReplica.add("localhost:31812");
        missingReplica.add("1.cluster.com");
        missingReplica.add("2.cluster.com");
        missingReplica.add("11.cluster.com");
        missingReplica.add("12.cluster.com");
        this.verifyMarkLedgerUnderreplicated(missingReplica);
    }

    @Test(dataProvider="impl")
    public void testManyFailuresInAnEnsemble(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        ArrayList<String> missingReplica = new ArrayList<String>();
        missingReplica.add("localhost:3181");
        missingReplica.add("localhost:3182");
        this.verifyMarkLedgerUnderreplicated(missingReplica);
    }

    @Test(dataProvider="impl")
    public void testDisableLedgerReplication(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        Long ledgerA = 1093839814060L;
        String missingReplica = "localhost:3181";
        this.lum.disableLedgerReplication();
        log.info("Disabled Ledeger Replication");
        try {
            this.lum.markLedgerUnderreplicated(ledgerA.longValue(), "localhost:3181");
        }
        catch (ReplicationException.UnavailableException e) {
            log.error("Unexpected exception while marking urLedger", (Throwable)e);
            Assert.fail((String)("Unexpected exception while marking urLedger" + e.getMessage()));
        }
        Future<Long> fA = this.getLedgerToReplicate(this.lum);
        try {
            fA.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testEnableLedgerReplication(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        final Long ledgerA = 1093839814060L;
        String missingReplica = "localhost:3181";
        try {
            this.lum.markLedgerUnderreplicated(ledgerA.longValue(), "localhost:3181");
        }
        catch (ReplicationException.UnavailableException e) {
            log.debug("Unexpected exception while marking urLedger", (Throwable)e);
            Assert.fail((String)("Unexpected exception while marking urLedger" + e.getMessage()));
        }
        this.lum.disableLedgerReplication();
        log.debug("Disabled Ledeger Replication");
        String znodeA = this.getUrLedgerZnode(ledgerA);
        final CountDownLatch znodeLatch = new CountDownLatch(2);
        String urledgerA = StringUtils.substringAfterLast((String)znodeA, (String)"/");
        String urLockLedgerA = this.basePath + "/locks/" + urledgerA;
        this.store.registerListener(n -> {
            if (n.getType() == NotificationType.Created && n.getPath().equals(urLockLedgerA)) {
                znodeLatch.countDown();
                log.debug("Recieved node creation event for the zNodePath:" + n.getPath());
            }
        });
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                try {
                    Long lA = LedgerUnderreplicationManagerTest.this.lum.getLedgerToRereplicate();
                    Assert.assertEquals((String)"Should be the ledger I just marked", (Object)lA, (Object)ledgerA);
                    znodeLatch.countDown();
                }
                catch (ReplicationException.UnavailableException e) {
                    e.printStackTrace();
                }
            }
        };
        thread1.start();
        try {
            Assert.assertFalse((String)"shouldn't complete", (boolean)znodeLatch.await(1L, TimeUnit.SECONDS));
            Assert.assertEquals((String)"Failed to disable ledger replication!", (long)2L, (long)znodeLatch.getCount());
            this.lum.enableLedgerReplication();
            znodeLatch.await(5L, TimeUnit.SECONDS);
            log.debug("Enabled Ledeger Replication");
            Assert.assertEquals((String)"Failed to disable ledger replication!", (long)0L, (long)znodeLatch.getCount());
        }
        finally {
            thread1.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testCheckAllLedgersCTime(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        LedgerUnderreplicationManager underReplicaMgr1 = this.lmf.newLedgerUnderreplicationManager();
        try {
            LedgerUnderreplicationManager underReplicaMgr2 = this.lmf.newLedgerUnderreplicationManager();
            try {
                Assert.assertEquals((long)-1L, (long)underReplicaMgr1.getCheckAllLedgersCTime());
                long curTime = System.currentTimeMillis();
                underReplicaMgr2.setCheckAllLedgersCTime(curTime);
                Assert.assertEquals((long)curTime, (long)underReplicaMgr1.getCheckAllLedgersCTime());
                curTime = System.currentTimeMillis();
                underReplicaMgr2.setCheckAllLedgersCTime(curTime);
                Assert.assertEquals((long)curTime, (long)underReplicaMgr1.getCheckAllLedgersCTime());
            }
            finally {
                if (Collections.singletonList(underReplicaMgr2).get(0) != null) {
                    underReplicaMgr2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(underReplicaMgr1).get(0) != null) {
                underReplicaMgr1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testPlacementPolicyCheckCTime(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        LedgerUnderreplicationManager underReplicaMgr1 = this.lmf.newLedgerUnderreplicationManager();
        try {
            LedgerUnderreplicationManager underReplicaMgr2 = this.lmf.newLedgerUnderreplicationManager();
            try {
                Assert.assertEquals((long)-1L, (long)underReplicaMgr1.getPlacementPolicyCheckCTime());
                long curTime = System.currentTimeMillis();
                underReplicaMgr2.setPlacementPolicyCheckCTime(curTime);
                Assert.assertEquals((long)curTime, (long)underReplicaMgr1.getPlacementPolicyCheckCTime());
                curTime = System.currentTimeMillis();
                underReplicaMgr2.setPlacementPolicyCheckCTime(curTime);
                Assert.assertEquals((long)curTime, (long)underReplicaMgr1.getPlacementPolicyCheckCTime());
            }
            finally {
                if (Collections.singletonList(underReplicaMgr2).get(0) != null) {
                    underReplicaMgr2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(underReplicaMgr1).get(0) != null) {
                underReplicaMgr1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testReplicasCheckCTime(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        LedgerUnderreplicationManager underReplicaMgr1 = this.lmf.newLedgerUnderreplicationManager();
        try {
            LedgerUnderreplicationManager underReplicaMgr2 = this.lmf.newLedgerUnderreplicationManager();
            try {
                Assert.assertEquals((long)-1L, (long)underReplicaMgr1.getReplicasCheckCTime());
                long curTime = System.currentTimeMillis();
                underReplicaMgr2.setReplicasCheckCTime(curTime);
                Assert.assertEquals((long)curTime, (long)underReplicaMgr1.getReplicasCheckCTime());
                curTime = System.currentTimeMillis();
                underReplicaMgr2.setReplicasCheckCTime(curTime);
                Assert.assertEquals((long)curTime, (long)underReplicaMgr1.getReplicasCheckCTime());
            }
            finally {
                if (Collections.singletonList(underReplicaMgr2).get(0) != null) {
                    underReplicaMgr2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(underReplicaMgr1).get(0) != null) {
                underReplicaMgr1.close();
            }
        }
    }

    private void verifyMarkLedgerUnderreplicated(Collection<String> missingReplica) throws Exception {
        Long ledgerA = 1093839814060L;
        String znodeA = this.getUrLedgerZnode(ledgerA);
        for (String replica : missingReplica) {
            this.lum.markLedgerUnderreplicated(ledgerA.longValue(), replica);
        }
        String urLedgerA = new String(((GetResult)((Optional)this.store.get(znodeA).join()).get()).getValue());
        DataFormats.UnderreplicatedLedgerFormat.Builder builderA = DataFormats.UnderreplicatedLedgerFormat.newBuilder();
        for (String replica : missingReplica) {
            builderA.addReplica(replica);
        }
        ProtocolStringList replicaList = builderA.getReplicaList();
        for (String replica : missingReplica) {
            Assert.assertTrue((String)("UrLedger:" + urLedgerA + " doesn't contain failed bookie :" + replica), (boolean)replicaList.contains(replica));
        }
    }

    private String getUrLedgerZnode(long ledgerId) {
        return ZkLedgerUnderreplicationManager.getUrLedgerZnode((String)this.urLedgerPath, (long)ledgerId);
    }

    private void takeLedgerAndRelease(LedgerUnderreplicationManager m, CountDownLatch latch, int numberOfIterations) {
        for (int i = 0; i < numberOfIterations; ++i) {
            try {
                long ledgerToRereplicate = m.getLedgerToRereplicate();
                m.releaseUnderreplicatedLedger(ledgerToRereplicate);
            }
            catch (ReplicationException.UnavailableException e) {
                log.error("UnavailableException when taking or releasing lock", (Throwable)e);
            }
            latch.countDown();
        }
    }
}

