/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.net.URI;
import org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.junit.Assert;
import org.testng.annotations.Test;

public class PulsarMetadataDriverBaseStaticTest {
    @Test
    public void testGetZKServersFromServiceUri() {
        String uriStr = "zk://server1;server2;server3/ledgers";
        URI uri = URI.create(uriStr);
        String zkServers = ZKMetadataDriverBase.getZKServersFromServiceUri((URI)uri);
        Assert.assertEquals((Object)"server1,server2,server3", (Object)zkServers);
        uriStr = "zk://server1,server2,server3/ledgers";
        uri = URI.create(uriStr);
        zkServers = ZKMetadataDriverBase.getZKServersFromServiceUri((URI)uri);
        Assert.assertEquals((Object)"server1,server2,server3", (Object)zkServers);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testResolveLedgerManagerFactoryNullUri() {
        ZKMetadataDriverBase.resolveLedgerManagerFactory(null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testResolveLedgerManagerFactoryNullScheme() {
        ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("//127.0.0.1/ledgers"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testResolveLedgerManagerFactoryUnknownScheme() {
        ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("unknown://127.0.0.1/ledgers"));
    }

    @Test
    public void testResolveLedgerManagerFactoryUnspecifiedLayout() {
        Assert.assertEquals(null, (Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk://127.0.0.1/ledgers")));
    }

    @Test
    public void testResolveLedgerManagerFactoryNullLayout() {
        Assert.assertEquals(null, (Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+null://127.0.0.1/ledgers")));
    }

    @Test
    public void testResolveLedgerManagerFactoryFlat() {
        Assert.assertEquals(FlatLedgerManagerFactory.class, (Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+flat://127.0.0.1/ledgers")));
    }

    @Test
    public void testResolveLedgerManagerFactoryMs() {
        Assert.assertEquals(MSLedgerManagerFactory.class, (Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+ms://127.0.0.1/ledgers")));
    }

    @Test
    public void testResolveLedgerManagerFactoryHierarchical() {
        Assert.assertEquals(HierarchicalLedgerManagerFactory.class, (Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+hierarchical://127.0.0.1/ledgers")));
    }

    @Test
    public void testResolveLedgerManagerFactoryLongHierarchical() {
        Assert.assertEquals(LongHierarchicalLedgerManagerFactory.class, (Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+longhierarchical://127.0.0.1/ledgers")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testResolveLedgerManagerFactoryUnknownLedgerManagerFactory() {
        ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+unknown://127.0.0.1/ledgers"));
    }
}

