/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.util.UUID;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarRegistrationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class PulsarRegistrationManagerTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(PulsarRegistrationManagerTest.class);
    private MetadataStoreExtended store;
    private RegistrationManager registrationManager;
    private String ledgersRootPath;

    private void methodSetup(Supplier<String> urlSupplier) throws Exception {
        this.ledgersRootPath = "/ledgers-" + UUID.randomUUID();
        this.store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        this.registrationManager = new PulsarRegistrationManager(this.store, this.ledgersRootPath, (AbstractConfiguration)new ServerConfiguration());
    }

    @AfterMethod(alwaysRun=true)
    public final void methodCleanup() throws Exception {
        if (this.registrationManager != null) {
            this.registrationManager.close();
            this.registrationManager = null;
        }
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Test(dataProvider="impl")
    public void testPrepareFormat(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        this.registrationManager.prepareFormat();
        Assert.assertTrue((boolean)((Boolean)this.store.exists(this.ledgersRootPath).join()));
    }

    @Test(dataProvider="impl")
    public void testGetClusterInstanceIdIfClusterNotInitialized(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        try {
            this.registrationManager.getClusterInstanceId();
            Assert.fail((String)"Should fail getting cluster instance id if cluster not initialized");
        }
        catch (BookieException.MetadataStoreException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("BookKeeper cluster not initialized"));
        }
    }

    @Test(dataProvider="impl")
    public void testGetClusterInstanceId(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        this.assertClusterNotExists();
        this.registrationManager.initNewCluster();
        String instanceId = this.registrationManager.getClusterInstanceId();
        UUID uuid = UUID.fromString(instanceId);
        log.info("Cluster instance id : {}", (Object)uuid);
    }

    @Test(dataProvider="impl")
    public void testNukeNonExistingCluster(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        this.assertClusterNotExists();
        Assert.assertTrue((boolean)this.registrationManager.nukeExistingCluster());
        this.assertClusterNotExists();
    }

    @Test(dataProvider="impl")
    public void testNukeExistingCluster(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        Assert.assertTrue((boolean)this.registrationManager.initNewCluster());
        this.assertClusterExists();
        Assert.assertTrue((boolean)this.registrationManager.nukeExistingCluster());
        this.assertClusterNotExists();
    }

    @Test(dataProvider="impl")
    public void testInitNewClusterTwice(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        Assert.assertTrue((boolean)this.registrationManager.initNewCluster());
        this.assertClusterExists();
        String instanceId = this.registrationManager.getClusterInstanceId();
        Assert.assertFalse((boolean)this.registrationManager.initNewCluster());
        this.assertClusterExists();
        Assert.assertEquals((String)instanceId, (String)this.registrationManager.getClusterInstanceId());
    }

    @Test(dataProvider="impl")
    public void testPrepareFormatNonExistingCluster(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        Assert.assertFalse((boolean)this.registrationManager.prepareFormat());
    }

    @Test(dataProvider="impl")
    public void testPrepareFormatExistingCluster(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        Assert.assertTrue((boolean)this.registrationManager.initNewCluster());
        this.assertClusterExists();
        Assert.assertTrue((boolean)this.registrationManager.prepareFormat());
    }

    @Test(dataProvider="impl")
    public void testNukeExistingClusterWithWritableBookies(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        this.testNukeExistingClusterWithBookies(false);
    }

    @Test(dataProvider="impl")
    public void testNukeExistingClusterWithReadonlyBookies(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        this.testNukeExistingClusterWithBookies(true);
    }

    private void testNukeExistingClusterWithBookies(boolean readonly) throws Exception {
        Assert.assertTrue((boolean)this.registrationManager.initNewCluster());
        this.assertClusterExists();
        this.createNumBookies(3, readonly);
        Assert.assertFalse((boolean)this.registrationManager.nukeExistingCluster());
        this.assertClusterExists();
        this.removeNumBookies(3, readonly);
        Assert.assertTrue((boolean)this.registrationManager.nukeExistingCluster());
        this.assertClusterNotExists();
    }

    @Test(dataProvider="impl")
    public void testNukeExistingClusterWithAllBookies(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        Assert.assertTrue((boolean)this.registrationManager.initNewCluster());
        this.assertClusterExists();
        this.createNumBookies(1, false);
        this.createNumBookies(2, true);
        Assert.assertFalse((boolean)this.registrationManager.nukeExistingCluster());
        this.assertClusterExists();
        this.removeNumBookies(1, false);
        this.removeNumBookies(2, true);
        Assert.assertTrue((boolean)this.registrationManager.nukeExistingCluster());
        this.assertClusterNotExists();
    }

    @Test(dataProvider="impl")
    public void testFormatNonExistingCluster(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        this.assertClusterNotExists();
        Assert.assertTrue((boolean)this.registrationManager.format());
        this.assertClusterExists();
    }

    @Test(dataProvider="impl")
    public void testFormatExistingCluster(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        this.assertClusterNotExists();
        Assert.assertTrue((boolean)this.registrationManager.initNewCluster());
        this.assertClusterExists();
        String clusterInstanceId = this.registrationManager.getClusterInstanceId();
        Assert.assertTrue((boolean)this.registrationManager.format());
        this.assertClusterExists();
        Assert.assertNotEquals((Object)clusterInstanceId, (Object)this.registrationManager.getClusterInstanceId());
    }

    @Test(dataProvider="impl")
    public void testFormatExistingClusterWithBookies(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        this.assertClusterNotExists();
        Assert.assertTrue((boolean)this.registrationManager.initNewCluster());
        this.assertClusterExists();
        String clusterInstanceId = this.registrationManager.getClusterInstanceId();
        this.createNumBookies(3, false);
        Assert.assertTrue((boolean)this.registrationManager.format());
        this.assertClusterExists();
    }

    private void createNumBookies(int numBookies, boolean readonly) throws Exception {
        for (int i = 0; i < numBookies; ++i) {
            BookieId bookieId = BookieId.parse((String)("bookie-" + i + ":3181"));
            this.registrationManager.registerBookie(bookieId, readonly, new BookieServiceInfo());
        }
    }

    private void removeNumBookies(int numBookies, boolean readonly) throws Exception {
        for (int i = 0; i < numBookies; ++i) {
            BookieId bookieId = BookieId.parse((String)("bookie-" + i + ":3181"));
            this.registrationManager.unregisterBookie(bookieId, readonly);
        }
    }

    private void assertClusterExists() {
        Assert.assertTrue((boolean)((Boolean)this.store.exists(this.ledgersRootPath + "/INSTANCEID").join()));
    }

    private void assertClusterNotExists() {
        Assert.assertFalse((boolean)((Boolean)this.store.exists(this.ledgersRootPath + "/INSTANCEID").join()));
    }
}

