/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.impl.BacklogQuotaImpl;
import org.apache.pulsar.metadata.cache.impl.JSONMetadataSerdeSimpleType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BacklogQuotaCompatibilityTest {
    private final JavaType typeRef = TypeFactory.defaultInstance().constructSimpleType(Policies.class, null);
    private final JSONMetadataSerdeSimpleType<Policies> simpleType = new JSONMetadataSerdeSimpleType(this.typeRef);
    private final BacklogQuota.RetentionPolicy testPolicy = BacklogQuota.RetentionPolicy.consumer_backlog_eviction;

    @Test
    public void testV27ClientSetV28BrokerRead() throws Exception {
        Policies writePolicy = new Policies();
        BacklogQuotaImpl writeBacklogQuota = new BacklogQuotaImpl();
        writeBacklogQuota.setLimit(1024L);
        writeBacklogQuota.setLimitTime(60);
        writeBacklogQuota.setPolicy(this.testPolicy);
        HashMap<BacklogQuota.BacklogQuotaType, BacklogQuotaImpl> quotaHashMap = new HashMap<BacklogQuota.BacklogQuotaType, BacklogQuotaImpl>();
        quotaHashMap.put(BacklogQuota.BacklogQuotaType.destination_storage, writeBacklogQuota);
        writePolicy.backlog_quota_map = quotaHashMap;
        byte[] serialize = this.simpleType.serialize((Object)writePolicy);
        Policies policies = (Policies)this.simpleType.deserialize(serialize);
        BacklogQuota readBacklogQuota = (BacklogQuota)policies.backlog_quota_map.get(BacklogQuota.BacklogQuotaType.destination_storage);
        Assert.assertEquals((long)readBacklogQuota.getLimitSize(), (long)1024L);
        Assert.assertEquals((int)readBacklogQuota.getLimitTime(), (int)60);
        Assert.assertEquals((Object)readBacklogQuota.getPolicy(), (Object)this.testPolicy);
    }

    @Test
    public void testV28ClientSetV28BrokerRead() throws Exception {
        Policies writePolicy = new Policies();
        BacklogQuotaImpl writeBacklogQuota = new BacklogQuotaImpl();
        writeBacklogQuota.setLimitSize(1024L);
        writeBacklogQuota.setLimitTime(60);
        writeBacklogQuota.setPolicy(this.testPolicy);
        HashMap<BacklogQuota.BacklogQuotaType, BacklogQuotaImpl> quotaHashMap = new HashMap<BacklogQuota.BacklogQuotaType, BacklogQuotaImpl>();
        quotaHashMap.put(BacklogQuota.BacklogQuotaType.destination_storage, writeBacklogQuota);
        writePolicy.backlog_quota_map = quotaHashMap;
        byte[] serialize = this.simpleType.serialize((Object)writePolicy);
        Policies policies = (Policies)this.simpleType.deserialize(serialize);
        BacklogQuota readBacklogQuota = (BacklogQuota)policies.backlog_quota_map.get(BacklogQuota.BacklogQuotaType.destination_storage);
        Assert.assertEquals((long)readBacklogQuota.getLimit(), (long)1024L);
        Assert.assertEquals((int)readBacklogQuota.getLimitTime(), (int)60);
        Assert.assertEquals((Object)readBacklogQuota.getPolicy(), (Object)this.testPolicy);
    }

    @Test
    public void testV28ClientSetV27BrokerRead() {
        BacklogQuotaImpl writeBacklogQuota = new BacklogQuotaImpl();
        writeBacklogQuota.setLimitSize(1024L);
        Assert.assertEquals((long)1024L, (long)writeBacklogQuota.getLimit());
    }

    @Test
    public void testBackwardCompatibility() throws IOException {
        String oldPolicyStr = "{\"auth_policies\":{\"namespace_auth\":{},\"destination_auth\":{},\"subscription_auth_roles\":{}},\"replication_clusters\":[],\"backlog_quota_map\":{\"destination_storage\":{\"limit\":1001,\"policy\":\"consumer_backlog_eviction\"}},\"clusterDispatchRate\":{},\"topicDispatchRate\":{},\"subscriptionDispatchRate\":{},\"replicatorDispatchRate\":{},\"clusterSubscribeRate\":{},\"publishMaxMessageRate\":{},\"latency_stats_sample_rate\":{},\"subscription_expiration_time_minutes\":0,\"deleted\":false,\"encryption_required\":false,\"subscription_auth_mode\":\"None\",\"max_consumers_per_subscription\":0,\"offload_threshold\":-1,\"schema_auto_update_compatibility_strategy\":\"Full\",\"schema_compatibility_strategy\":\"UNDEFINED\",\"is_allow_auto_update_schema\":true,\"schema_validation_enforced\":false,\"subscription_types_enabled\":[]}\n";
        Policies policies = (Policies)this.simpleType.deserialize(oldPolicyStr.getBytes());
        Assert.assertEquals((long)((BacklogQuota)policies.backlog_quota_map.get(BacklogQuota.BacklogQuotaType.destination_storage)).getLimitSize(), (long)1001L);
        Assert.assertEquals((int)((BacklogQuota)policies.backlog_quota_map.get(BacklogQuota.BacklogQuotaType.destination_storage)).getLimitTime(), (int)0);
        Assert.assertEquals((Object)((BacklogQuota)policies.backlog_quota_map.get(BacklogQuota.BacklogQuotaType.destination_storage)).getPolicy(), (Object)BacklogQuota.RetentionPolicy.consumer_backlog_eviction);
    }
}

