/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.util.concurrent.CompletionException;
import org.apache.pulsar.metadata.TestZKServer;
import org.apache.pulsar.tests.TestRetrySupport;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public abstract class BaseMetadataStoreTest
extends TestRetrySupport {
    protected TestZKServer zks;

    @BeforeClass(alwaysRun=true)
    protected void setup() throws Exception {
        this.incrementSetupNumber();
        this.zks = new TestZKServer();
    }

    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        this.markCurrentSetupNumberCleaned();
        this.zks.close();
    }

    @DataProvider(name="impl")
    public Object[][] implementations() {
        return new Object[][]{{"ZooKeeper", this.zks.getConnectionString()}, {"Memory", "memory://local"}};
    }

    protected String newKey() {
        return "/key-" + System.nanoTime();
    }

    static void assertException(CompletionException e, Class<?> clazz) {
        BaseMetadataStoreTest.assertException(e.getCause(), clazz);
    }

    static void assertException(Throwable t, Class<?> clazz) {
        Assert.assertTrue((boolean)clazz.isInstance(t), (String)String.format("Exception %s is not of type %s", t.getClass(), clazz));
    }
}

