/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.coordination.LockManager;
import org.apache.pulsar.metadata.api.coordination.ResourceLock;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.coordination.impl.CoordinationServiceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LockManagerTest
extends BaseMetadataStoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void acquireLocks(String provider, String url) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            CoordinationServiceImpl coordinationService = new CoordinationServiceImpl(store);
            try {
                LockManager lockManager = coordinationService.getLockManager(String.class);
                try {
                    Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), Collections.emptyList());
                    Assert.assertEquals(lockManager.readLock("/my/path/1").join(), Optional.empty());
                    ResourceLock lock1 = (ResourceLock)lockManager.acquireLock("/my/path/1", (Object)"lock-1").join();
                    Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), Collections.singletonList("1"));
                    Assert.assertEquals(lockManager.readLock("/my/path/1").join(), Optional.of("lock-1"));
                    Assert.assertEquals((String)lock1.getPath(), (String)"/my/path/1");
                    Assert.assertEquals((String)((String)lock1.getValue()), (String)"lock-1");
                    CountDownLatch latchLock1 = new CountDownLatch(1);
                    lock1.getLockExpiredFuture().thenRun(() -> latchLock1.countDown());
                    Assert.assertEquals((long)latchLock1.getCount(), (long)1L);
                    Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), Collections.singletonList("1"));
                    Assert.assertEquals(lockManager.readLock("/my/path/1").join(), Optional.of("lock-1"));
                    Assert.assertEquals((long)latchLock1.getCount(), (long)1L);
                    lock1.release().join();
                    Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), Collections.emptyList());
                    Assert.assertEquals(lockManager.readLock("/my/path/1").join(), Optional.empty());
                    latchLock1.await(0L, TimeUnit.SECONDS);
                    lock1.release().join();
                    ResourceLock lock2 = (ResourceLock)lockManager.acquireLock("/my/path/1", (Object)"lock-1").join();
                    Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), Collections.singletonList("1"));
                    Assert.assertEquals(lockManager.readLock("/my/path/1").join(), Optional.of("lock-1"));
                    Assert.assertEquals((String)lock2.getPath(), (String)"/my/path/1");
                    Assert.assertEquals((String)((String)lock2.getValue()), (String)"lock-1");
                }
                finally {
                    if (Collections.singletonList(lockManager).get(0) != null) {
                        lockManager.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(coordinationService).get(0) != null) {
                    coordinationService.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void cleanupOnClose(String provider, String url) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            CoordinationServiceImpl coordinationService = new CoordinationServiceImpl(store);
            try {
                LockManager lockManager = coordinationService.getLockManager(String.class);
                Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), Collections.emptyList());
                Assert.assertEquals(lockManager.readLock("/my/path/1").join(), Optional.empty());
                lockManager.acquireLock("/my/path/1", (Object)"lock-1").join();
                Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), Collections.singletonList("1"));
                Assert.assertEquals(lockManager.readLock("/my/path/1").join(), Optional.of("lock-1"));
                lockManager.acquireLock("/my/path/2", (Object)"lock-2").join();
                Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), new ArrayList<String>(Arrays.asList("1", "2")));
                Assert.assertEquals(lockManager.readLock("/my/path/2").join(), Optional.of("lock-2"));
                lockManager.close();
                lockManager = coordinationService.getLockManager(String.class);
                Assert.assertEquals((Collection)((Collection)lockManager.listLocks("/my/path").join()), Collections.emptyList());
                Assert.assertEquals(lockManager.readLock("/my/path/1").join(), Optional.empty());
                Assert.assertEquals(lockManager.readLock("/my/path/2").join(), Optional.empty());
            }
            finally {
                if (Collections.singletonList(coordinationService).get(0) != null) {
                    coordinationService.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void updateValue(String provider, String url) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache cache = store.getMetadataCache(String.class);
            CoordinationServiceImpl coordinationService = new CoordinationServiceImpl(store);
            try {
                LockManager lockManager = coordinationService.getLockManager(String.class);
                try {
                    ResourceLock lock = (ResourceLock)lockManager.acquireLock("/my/path/1", (Object)"lock-1").join();
                    Assert.assertEquals((String)((String)lock.getValue()), (String)"lock-1");
                    Assert.assertEquals((String)((String)((Optional)cache.get("/my/path/1").join()).get()), (String)"lock-1");
                    lock.updateValue((Object)"value-2").join();
                    Assert.assertEquals((String)((String)lock.getValue()), (String)"value-2");
                    Assert.assertEquals((String)((String)((Optional)cache.get("/my/path/1").join()).get()), (String)"value-2");
                }
                finally {
                    if (Collections.singletonList(lockManager).get(0) != null) {
                        lockManager.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(coordinationService).get(0) != null) {
                    coordinationService.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void revalidateLockWithinSameSession(String provider, String url) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            CoordinationServiceImpl cs2 = new CoordinationServiceImpl(store);
            try {
                LockManager lm2 = cs2.getLockManager(String.class);
                try {
                    String path1 = this.newKey();
                    store.put(path1, "\"value-1\"".getBytes(StandardCharsets.UTF_8), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
                    ResourceLock rl2 = (ResourceLock)lm2.acquireLock(path1, (Object)"value-1").join();
                    Assert.assertEquals((String)new String(((GetResult)((Optional)store.get(path1).join()).get()).getValue()), (String)"\"value-1\"");
                    Assert.assertFalse((boolean)rl2.getLockExpiredFuture().isDone());
                    String path2 = this.newKey();
                    store.put(path2, "\"value-1\"".getBytes(StandardCharsets.UTF_8), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
                    rl2 = (ResourceLock)lm2.acquireLock(path2, (Object)"value-2").join();
                    Assert.assertEquals((String)new String(((GetResult)((Optional)store.get(path2).join()).get()).getValue()), (String)"\"value-2\"");
                    Assert.assertFalse((boolean)rl2.getLockExpiredFuture().isDone());
                }
                finally {
                    if (Collections.singletonList(lm2).get(0) != null) {
                        lm2.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(cs2).get(0) != null) {
                    cs2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void revalidateLockOnDifferentSession(String provider, String url) throws Exception {
        if (provider.equals("Memory")) {
            return;
        }
        MetadataStoreExtended store1 = MetadataStoreExtended.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataStoreExtended store2 = MetadataStoreExtended.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
            try {
                CoordinationServiceImpl cs1 = new CoordinationServiceImpl(store1);
                try {
                    LockManager lm1 = cs1.getLockManager(String.class);
                    try {
                        CoordinationServiceImpl cs2 = new CoordinationServiceImpl(store2);
                        try {
                            LockManager lm2 = cs2.getLockManager(String.class);
                            try {
                                String path1 = this.newKey();
                                ResourceLock rl1 = (ResourceLock)lm1.acquireLock(path1, (Object)"value-1").join();
                                try {
                                    lm2.acquireLock(path1, (Object)"value-2").join();
                                }
                                catch (CompletionException e) {
                                    Assert.assertEquals(e.getCause().getClass(), MetadataStoreException.LockBusyException.class);
                                }
                                Assert.assertFalse((boolean)rl1.getLockExpiredFuture().isDone());
                                Assert.assertEquals((String)new String(((GetResult)((Optional)store1.get(path1).join()).get()).getValue()), (String)"\"value-1\"");
                                String path2 = this.newKey();
                                rl1 = (ResourceLock)lm1.acquireLock(path2, (Object)"value-1").join();
                                ResourceLock rl2 = (ResourceLock)lm2.acquireLock(path2, (Object)"value-1").join();
                                Assert.assertFalse((boolean)rl1.getLockExpiredFuture().isDone());
                                Assert.assertFalse((boolean)rl2.getLockExpiredFuture().isDone());
                                Assert.assertEquals((String)new String(((GetResult)((Optional)store1.get(path2).join()).get()).getValue()), (String)"\"value-1\"");
                            }
                            finally {
                                if (Collections.singletonList(lm2).get(0) != null) {
                                    lm2.close();
                                }
                            }
                        }
                        finally {
                            if (Collections.singletonList(cs2).get(0) != null) {
                                cs2.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(lm1).get(0) != null) {
                            lm1.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(cs1).get(0) != null) {
                        cs1.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }
}

