/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.CacheGetResult;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.Stat;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MetadataCacheTest
extends BaseMetadataStoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void emptyCacheTest(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache(MyClass.class);
            Assert.assertEquals((Object)objCache.getIfCached("/non-existing-key"), Optional.empty());
            Assert.assertEquals((Object)objCache.getIfCached("/non-existing-key/child"), Optional.empty());
            Assert.assertEquals(objCache.get("/non-existing-key").join(), Optional.empty());
            Assert.assertEquals(objCache.get("/non-existing-key/child").join(), Optional.empty());
            try {
                objCache.delete("/non-existing-key").join();
                Assert.fail((String)"should have failed");
            }
            catch (CompletionException e) {
                Assert.assertEquals(e.getCause().getClass(), MetadataStoreException.NotFoundException.class);
            }
            try {
                objCache.delete("/non-existing-key/child").join();
                Assert.fail((String)"should have failed");
            }
            catch (CompletionException e) {
                Assert.assertEquals(e.getCause().getClass(), MetadataStoreException.NotFoundException.class);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    @DataProvider(name="zk")
    public Object[][] zkimplementations() {
        return new Object[][]{{"ZooKeeper", this.zks.getConnectionString()}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="zk")
    public void crossStoreUpdates(String provider, String url) throws Exception {
        MetadataStore store1 = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataStore store2 = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
            try {
                MetadataStore store3 = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
                try {
                    MetadataCache objCache1 = store1.getMetadataCache(MyClass.class);
                    MetadataCache objCache2 = store2.getMetadataCache(MyClass.class);
                    MetadataCache objCache3 = store3.getMetadataCache(MyClass.class);
                    ArrayList<MetadataCache<MyClass>> allCaches = new ArrayList<MetadataCache<MyClass>>();
                    allCaches.add(objCache1);
                    allCaches.add(objCache2);
                    allCaches.add(objCache3);
                    this.multiStoreAddDelete(allCaches, 0, 1, "add cache0 del cache1");
                    this.multiStoreAddDelete(allCaches, 0, 1, "add cache0 del cache1");
                    this.multiStoreAddDelete(allCaches, 1, 0, "add cache1 del cache0");
                    this.multiStoreAddDelete(allCaches, 1, 1, "add cache1 del cache1");
                }
                finally {
                    if (Collections.singletonList(store3).get(0) != null) {
                        store3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }

    private void multiStoreAddDelete(List<MetadataCache<MyClass>> caches, int addOn, int delFrom, String testName) throws InterruptedException {
        MetadataCache<MyClass> addCache = caches.get(addOn);
        MetadataCache<MyClass> delCache = caches.get(delFrom);
        String key1 = "/test-key1";
        Assert.assertEquals((Object)addCache.getIfCached(key1), Optional.empty());
        MyClass value1 = new MyClass(testName, 1);
        addCache.create(key1, (Object)value1).join();
        Awaitility.await().ignoreExceptions().untilAsserted(() -> {
            for (MetadataCache cache : caches) {
                if (cache == addCache) {
                    Assert.assertEquals((Object)cache.getIfCached(key1), Optional.of(value1));
                }
                Assert.assertEquals(cache.get(key1).join(), Optional.of(value1));
                Assert.assertEquals((Object)cache.getIfCached(key1), Optional.of(value1));
            }
        });
        delCache.delete(key1).join();
        Awaitility.await().ignoreExceptions().untilAsserted(() -> {
            for (MetadataCache cache : caches) {
                Assert.assertEquals((Object)cache.getIfCached(key1), Optional.empty());
                Assert.assertEquals(cache.get(key1).join(), Optional.empty());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void insertionDeletionWitGenericType(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache((TypeReference)new TypeReference<Map<String, String>>(){});
            String key1 = this.newKey();
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.empty());
            TreeMap<String, String> v = new TreeMap<String, String>();
            v.put("a", "1");
            v.put("b", "2");
            objCache.create(key1, v).join();
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.of(v));
            Assert.assertEquals(objCache.get(key1).join(), Optional.of(v));
            objCache.delete(key1).join();
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.empty());
            Assert.assertEquals(objCache.get(key1).join(), Optional.empty());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void insertionDeletion(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache(MyClass.class);
            String key1 = this.newKey();
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.empty());
            MyClass value1 = new MyClass("a", 1);
            objCache.create(key1, (Object)value1).join();
            MyClass value2 = new MyClass("a", 2);
            try {
                objCache.create(key1, (Object)value2).join();
                Assert.fail((String)"should have failed to create");
            }
            catch (CompletionException e) {
                Assert.assertEquals(e.getCause().getClass(), MetadataStoreException.AlreadyExistsException.class);
            }
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.of(value1));
            Assert.assertEquals(objCache.get(key1).join(), Optional.of(value1));
            Assert.assertEquals(objCache.readModifyUpdateOrCreate(key1, __ -> value2).join(), (Object)value2);
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.of(value2));
            Assert.assertEquals(objCache.get(key1).join(), Optional.of(value2));
            objCache.delete(key1).join();
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.empty());
            Assert.assertEquals(objCache.get(key1).join(), Optional.empty());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void insertionOutsideCache(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache(MyClass.class);
            String key1 = this.newKey();
            MyClass value1 = new MyClass("a", 1);
            store.put(key1, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)value1), Optional.of(-1L)).join();
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.empty());
            Assert.assertEquals(objCache.get(key1).join(), Optional.of(value1));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void insertionOutsideCacheWithGenericType(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache((TypeReference)new TypeReference<Map<String, String>>(){});
            String key1 = this.newKey();
            TreeMap<String, String> v = new TreeMap<String, String>();
            v.put("a", "1");
            v.put("b", "2");
            store.put(key1, ObjectMapperFactory.getThreadLocal().writeValueAsBytes(v), Optional.of(-1L)).join();
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.empty());
            Assert.assertEquals(objCache.get(key1).join(), Optional.of(v));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void invalidJsonContent(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache(MyClass.class);
            String key1 = this.newKey();
            store.put(key1, "-------".getBytes(), Optional.of(-1L)).join();
            try {
                objCache.get(key1).join();
                Assert.fail((String)"should have failed to deserialize");
            }
            catch (CompletionException e) {
                Assert.assertEquals(e.getCause().getClass(), MetadataStoreException.ContentDeserializationException.class);
            }
            Assert.assertEquals((Object)objCache.getIfCached(key1), Optional.empty());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testReadCloned(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache(Policies.class);
            String path = "/testReadCloned-policies";
            Policies policies = new Policies();
            policies.max_unacked_messages_per_consumer = 100;
            policies.replication_clusters.add("1");
            objCache.create(path, (Object)policies).get();
            Policies tempPolicies = (Policies)((Optional)objCache.get(path).get()).get();
            Assert.assertSame((Object)tempPolicies, ((Optional)objCache.get(path).get()).get());
            AtomicReference<Policies> reference = new AtomicReference<Policies>(new Policies());
            AtomicReference<Policies> reference2 = new AtomicReference<Policies>(new Policies());
            objCache.readModifyUpdate(path, policies1 -> {
                Assert.assertNotSame((Object)policies1, (Object)tempPolicies);
                reference.set((Policies)policies1);
                policies1.max_unacked_messages_per_consumer = 200;
                return policies1;
            }).get();
            objCache.readModifyUpdate(path, policies1 -> {
                Assert.assertNotSame((Object)policies1, (Object)tempPolicies);
                reference2.set((Policies)policies1);
                policies1.max_unacked_messages_per_consumer = 300;
                return policies1;
            }).get();
            Assert.assertEquals((int)tempPolicies.max_unacked_messages_per_consumer, (int)100);
            Assert.assertNotSame((Object)reference.get(), (Object)reference2.get());
            Assert.assertNotEquals((Object)reference.get().max_unacked_messages_per_consumer, (Object)reference2.get().max_unacked_messages_per_consumer);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testCloneInReadModifyUpdateOrCreate(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache(Policies.class);
            String path = "/testCloneInReadModifyUpdateOrCreate-policies";
            Policies policies = new Policies();
            policies.max_unacked_messages_per_consumer = 100;
            objCache.create(path, (Object)policies).get();
            Policies tempPolicies = (Policies)((Optional)objCache.get(path).get()).get();
            Assert.assertSame((Object)tempPolicies, ((Optional)objCache.get(path).get()).get());
            AtomicReference<Policies> reference = new AtomicReference<Policies>(new Policies());
            AtomicReference<Policies> reference2 = new AtomicReference<Policies>(new Policies());
            objCache.readModifyUpdateOrCreate(path, policies1 -> {
                Policies policiesRef = (Policies)policies1.get();
                Assert.assertNotSame((Object)policiesRef, (Object)tempPolicies);
                reference.set(policiesRef);
                policiesRef.max_unacked_messages_per_consumer = 200;
                return policiesRef;
            }).get();
            objCache.readModifyUpdateOrCreate(path, policies1 -> {
                Policies policiesRef = (Policies)policies1.get();
                Assert.assertNotSame((Object)policiesRef, (Object)tempPolicies);
                reference2.set(policiesRef);
                policiesRef.max_unacked_messages_per_consumer = 300;
                return policiesRef;
            }).get();
            Assert.assertEquals((int)tempPolicies.max_unacked_messages_per_consumer, (int)100);
            Assert.assertNotSame((Object)reference.get(), (Object)reference2.get());
            Assert.assertNotEquals((Object)reference.get().max_unacked_messages_per_consumer, (Object)reference2.get().max_unacked_messages_per_consumer);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void readModifyUpdate(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache(MyClass.class);
            String key1 = this.newKey();
            MyClass value1 = new MyClass("a", 1);
            objCache.create(key1, (Object)value1).join();
            Assert.assertEquals(objCache.readModifyUpdate(key1, v -> new MyClass(v.a, v.b + 1)).join(), (Object)new MyClass("a", 2));
            Optional newValue1 = (Optional)objCache.get(key1).join();
            Assert.assertTrue((boolean)newValue1.isPresent());
            Assert.assertEquals((String)((MyClass)newValue1.get()).a, (String)"a");
            Assert.assertEquals((int)((MyClass)newValue1.get()).b, (int)2);
            try {
                objCache.readModifyUpdate(this.newKey(), v -> new MyClass(v.a, v.b + 1)).join();
            }
            catch (CompletionException e) {
                Assert.assertEquals(e.getCause().getClass(), MetadataStoreException.NotFoundException.class);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readModifyUpdateBadVersionRetry() throws Exception {
        String url = this.zks.getConnectionString();
        MetadataStore sourceStore1 = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataStore sourceStore2 = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
            MetadataCache objCache1 = sourceStore1.getMetadataCache(MyClass.class);
            MetadataCache objCache2 = sourceStore2.getMetadataCache(MyClass.class);
            String key1 = this.newKey();
            MyClass value1 = new MyClass("a", 1);
            objCache1.create(key1, (Object)value1).join();
            objCache1.get(key1).join();
            objCache2.readModifyUpdate(key1, v -> new MyClass(v.a, v.b + 1)).join();
            objCache1.readModifyUpdate(key1, v -> new MyClass(v.a, v.b + 1)).join();
        }
        finally {
            if (Collections.singletonList(sourceStore1).get(0) != null) {
                sourceStore1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void getWithStats(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache(MyClass.class);
            String key1 = this.newKey();
            MyClass value1 = new MyClass("a", 1);
            Stat stat1 = (Stat)store.put(key1, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)value1), Optional.of(-1L)).join();
            CacheGetResult res = (CacheGetResult)((Optional)objCache.getWithStats(key1).join()).get();
            Assert.assertEquals((Object)res.getValue(), (Object)value1);
            Assert.assertEquals((long)res.getStat().getVersion(), (long)stat1.getVersion());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void cacheWithCustomSerde(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataCache objCache = store.getMetadataCache((MetadataSerde)new MetadataSerde<Integer>(){

                public byte[] serialize(Integer value) throws IOException {
                    return value.toString().getBytes(StandardCharsets.UTF_8);
                }

                public Integer deserialize(byte[] content) throws IOException {
                    return Integer.parseInt(new String(content, StandardCharsets.UTF_8));
                }
            });
            String key1 = this.newKey();
            objCache.create(key1, (Object)1).join();
            Assert.assertEquals(((Optional)objCache.get(key1).join()).get(), (Object)1);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    static class MyClass {
        String a;
        int b;

        public String getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public void setA(String a) {
            this.a = a;
        }

        public void setB(int b) {
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MyClass)) {
                return false;
            }
            MyClass other = (MyClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getB() != other.getB()) {
                return false;
            }
            String this$a = this.getA();
            String other$a = other.getA();
            return !(this$a == null ? other$a != null : !this$a.equals(other$a));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MyClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getB();
            String $a = this.getA();
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            return result;
        }

        public String toString() {
            return "MetadataCacheTest.MyClass(a=" + this.getA() + ", b=" + this.getB() + ")";
        }

        public MyClass(String a, int b) {
            this.a = a;
            this.b = b;
        }

        public MyClass() {
        }
    }
}

