/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataStoreExtendedTest
extends BaseMetadataStoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void sequentialKeys(String provider, String url) throws Exception {
        String basePath = "/my/path";
        MetadataStoreExtended store = MetadataStoreExtended.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            Stat stat1 = (Stat)store.put("/my/path", "value-1".getBytes(), Optional.of(-1L), EnumSet.of(CreateOption.Sequential)).join();
            Assert.assertNotNull((Object)stat1);
            Assert.assertEquals((long)stat1.getVersion(), (long)0L);
            Assert.assertNotEquals((Object)stat1.getPath(), (Object)"/my/path");
            Assert.assertEquals((byte[])((GetResult)((Optional)store.get(stat1.getPath()).join()).get()).getValue(), (byte[])"value-1".getBytes());
            String seq1 = stat1.getPath().replace("/my/path", "");
            long n1 = Long.parseLong(seq1);
            Stat stat2 = (Stat)store.put("/my/path", "value-2".getBytes(), Optional.of(-1L), EnumSet.of(CreateOption.Sequential)).join();
            Assert.assertNotNull((Object)stat2);
            Assert.assertEquals((long)stat2.getVersion(), (long)0L);
            Assert.assertNotEquals((Object)stat2.getPath(), (Object)"/my/path");
            Assert.assertNotEquals((Object)stat2.getPath(), (Object)stat1.getPath());
            Assert.assertEquals((byte[])((GetResult)((Optional)store.get(stat2.getPath()).join()).get()).getValue(), (byte[])"value-2".getBytes());
            String seq2 = stat2.getPath().replace("/my/path", "");
            long n2 = Long.parseLong(seq2);
            Assert.assertNotEquals((Object)seq1, (Object)seq2);
            Assert.assertNotEquals((Object)n1, (Object)n2);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }
}

