/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.Stat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataStoreTest
extends BaseMetadataStoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void emptyStoreTest(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            Assert.assertFalse((boolean)((Boolean)store.exists("/non-existing-key").join()));
            Assert.assertFalse((boolean)((Boolean)store.exists("/non-existing-key/child").join()));
            Assert.assertFalse((boolean)((Optional)store.get("/non-existing-key").join()).isPresent());
            Assert.assertFalse((boolean)((Optional)store.get("/non-existing-key/child").join()).isPresent());
            Assert.assertEquals((Collection)((Collection)store.getChildren("/non-existing-key").join()), Collections.emptyList());
            Assert.assertEquals((Collection)((Collection)store.getChildren("/non-existing-key/child").join()), Collections.emptyList());
            try {
                store.delete("/non-existing-key", Optional.empty()).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.NotFoundException.class);
            }
            try {
                store.delete("/non-existing-key", Optional.of(1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.NotFoundException.class);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void insertionTestWithExpectedVersion(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String key1 = this.newKey();
            try {
                store.put(key1, "value-1".getBytes(), Optional.of(0L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            try {
                store.put(key1, "value-1".getBytes(), Optional.of(1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            store.put(key1, "value-1".getBytes(), Optional.of(-1L)).join();
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            Optional optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-1".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)0L);
            try {
                store.put(key1, "value-2".getBytes(), Optional.of(-1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            try {
                store.put(key1, "value-2".getBytes(), Optional.of(1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-1".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)0L);
            store.put(key1, "value-2".getBytes(), Optional.of(0L)).join();
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-2".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)1L);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void getChildrenTest(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            int i;
            String key = this.newKey();
            int N = 10;
            ArrayList<String> expectedChildren = new ArrayList<String>();
            for (i = 0; i < N; ++i) {
                store.put(key + "/c-" + i, new byte[0], Optional.empty()).join();
                expectedChildren.add("c-" + i);
            }
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), expectedChildren);
            for (i = 0; i < N; ++i) {
                store.put(key + "/c-0/cc-" + i, new byte[0], Optional.empty()).join();
            }
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), expectedChildren);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void deletionTest(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String key = this.newKey();
            int N = 10;
            ArrayList<String> expectedChildren = new ArrayList<String>();
            for (int i = 0; i < N; ++i) {
                store.put(key + "/c-" + i, new byte[0], Optional.empty()).join();
                expectedChildren.add("c-" + i);
            }
            try {
                store.delete(key, Optional.empty()).join();
                Assert.fail((String)"The key has children");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            for (int i = 0; i < N; ++i) {
                try {
                    store.delete(key + "/c-" + i, Optional.of(1L)).join();
                    Assert.fail((String)"The key has children");
                }
                catch (CompletionException e) {
                    MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
                }
                store.delete(key + "/c-" + i, Optional.empty()).join();
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void emptyKeyTest(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            try {
                store.delete("", Optional.empty()).join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.getChildren("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.get("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.exists("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.put("", new byte[0], Optional.empty()).join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void notificationListeners(String provider, String url) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            LinkedBlockingDeque notifications = new LinkedBlockingDeque();
            store.registerListener(n -> notifications.add(n));
            String key1 = this.newKey();
            Assert.assertFalse((boolean)((Optional)store.get(key1).join()).isPresent());
            Stat stat = (Stat)store.put(key1, "value-1".getBytes(), Optional.empty()).join();
            Assert.assertTrue((boolean)((Optional)store.get(key1).join()).isPresent());
            Assert.assertEquals((Collection)((Collection)store.getChildren(key1).join()), Collections.emptyList());
            Assert.assertEquals((long)stat.getVersion(), (long)0L);
            Notification n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Created);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            stat = (Stat)store.put(key1, "value-2".getBytes(), Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Modified);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            Assert.assertEquals((long)stat.getVersion(), (long)1L);
            String key1Child = key1 + "/xx";
            Assert.assertFalse((boolean)((Optional)store.get(key1Child).join()).isPresent());
            store.put(key1Child, "value-2".getBytes(), Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Created);
            Assert.assertEquals((String)n2.getPath(), (String)key1Child);
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.ChildrenChanged);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            Assert.assertTrue((boolean)((Boolean)store.exists(key1Child).join()));
            Assert.assertEquals((Collection)((Collection)store.getChildren(key1).join()), Collections.singletonList("xx"));
            store.delete(key1Child, Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Deleted);
            Assert.assertEquals((String)n2.getPath(), (String)key1Child);
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.ChildrenChanged);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }
}

