/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.coordination.impl.CoordinationServiceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CounterTest
extends BaseMetadataStoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void basicTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            CoordinationServiceImpl cs1 = new CoordinationServiceImpl(store);
            try {
                long l1 = (Long)cs1.getNextCounterValue("/my/path").join();
                long l2 = (Long)cs1.getNextCounterValue("/my/path").join();
                long l3 = (Long)cs1.getNextCounterValue("/my/path").join();
                Assert.assertNotEquals((Object)l1, (Object)l2);
                Assert.assertNotEquals((Object)l2, (Object)l3);
                CoordinationServiceImpl cs2 = new CoordinationServiceImpl(store);
                try {
                    long l4 = (Long)cs1.getNextCounterValue("/my/path").join();
                    Assert.assertNotEquals((Object)l3, (Object)l4);
                }
                finally {
                    if (Collections.singletonList(cs2).get(0) != null) {
                        cs2.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(cs1).get(0) != null) {
                    cs1.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testCounterDoesNotAutoReset(String provider, Supplier<String> urlSupplier) throws Exception {
        if (provider.equals("Memory")) {
            return;
        }
        MetadataStoreExtended store1 = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        CoordinationServiceImpl cs1 = new CoordinationServiceImpl(store1);
        long l1 = (Long)cs1.getNextCounterValue("/my/path").join();
        long l2 = (Long)cs1.getNextCounterValue("/my/path").join();
        long l3 = (Long)cs1.getNextCounterValue("/my/path").join();
        Assert.assertNotEquals((Object)l1, (Object)l2);
        Assert.assertNotEquals((Object)l2, (Object)l3);
        cs1.close();
        store1.close();
        this.zks.checkContainers();
        MetadataStoreExtended store2 = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        CoordinationServiceImpl cs2 = new CoordinationServiceImpl(store2);
        try {
            long l4 = (Long)cs2.getNextCounterValue("/my/path").join();
            Assert.assertNotEquals((Object)l1, (Object)l4);
            Assert.assertNotEquals((Object)l2, (Object)l4);
            Assert.assertNotEquals((Object)l3, (Object)l4);
        }
        finally {
            if (Collections.singletonList(cs2).get(0) != null) {
                cs2.close();
            }
        }
    }
}

