/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.assertj.core.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class TestZKServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TestZKServer.class);
    protected ZooKeeperServer zks;
    private final File zkDataDir = Files.newTemporaryFolder();
    private ServerCnxnFactory serverFactory;
    private ContainerManager containerManager;
    private int zkPort = 0;

    public TestZKServer() throws Exception {
        this.zkDataDir.deleteOnExit();
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        System.setProperty("zookeeper.admin.enableServer", "false");
        this.start();
    }

    public void start() throws Exception {
        this.zks = new ZooKeeperServer(this.zkDataDir, this.zkDataDir, 3000);
        this.serverFactory = new NIOServerCnxnFactory();
        this.serverFactory.configure(new InetSocketAddress(this.zkPort), 1000);
        this.serverFactory.startup(this.zks, true);
        this.zkPort = this.serverFactory.getLocalPort();
        log.info("Started test ZK server on port {}", (Object)this.zkPort);
        boolean zkServerReady = TestZKServer.waitForServerUp(this.getConnectionString(), 30000L);
        Assert.assertTrue((boolean)zkServerReady);
        this.containerManager = new ContainerManager(this.zks.getZKDatabase(), new RequestProcessor(){

            public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
                String path = StandardCharsets.UTF_8.decode(request.request).toString();
                try {
                    TestZKServer.this.zks.getZKDatabase().getDataTree().deleteNode(path, -1L);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }

            public void shutdown() {
            }
        }, 10, 10000, 0L);
    }

    public void checkContainers() throws Exception {
        this.containerManager.checkContainers();
    }

    public void stop() throws Exception {
        if (this.zks != null) {
            this.zks.shutdown();
            this.zks.getZKDatabase().close();
            this.zks = null;
        }
        if (this.serverFactory != null) {
            this.serverFactory.shutdown();
            this.serverFactory = null;
        }
        log.info("Stopped test ZK server");
    }

    public void expireSession(final long sessionId) {
        this.zks.expire(new SessionTracker.Session(){

            public long getSessionId() {
                return sessionId;
            }

            public int getTimeout() {
                return 10000;
            }

            public boolean isClosing() {
                return false;
            }
        });
    }

    @Override
    public void close() throws Exception {
        this.stop();
        FileUtils.deleteDirectory((File)this.zkDataDir);
    }

    public int getPort() {
        return this.zkPort;
    }

    public String getConnectionString() {
        return "127.0.0.1:" + this.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        String[] split = hp.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try {
                Socket sock = new Socket(host, port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        log.info("ZK Server UP");
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                log.info("ZK server {} not up: {}", (Object)hp, (Object)e.getMessage());
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

