/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.replication.BookKeeperClusterTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuditorBookieTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorBookieTest.class);
    private String electionPath;
    private HashMap<String, AuditorElector> auditorElectors = new HashMap();
    private List<ZooKeeper> zkClients = new LinkedList<ZooKeeper>();

    public AuditorBookieTest() throws Exception {
        super(6);
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver");
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver");
    }

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.electionPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf) + "/underreplication/leader";
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        this.startAuditorElectors();
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        this.stopAuditorElectors();
        for (ZooKeeper zk : this.zkClients) {
            zk.close();
        }
        this.zkClients.clear();
        super.tearDown();
    }

    @Test
    public void testEnsureOnlySingleAuditor() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        int indexOf = this.indexOfServer(auditor);
        int bkIndexDownBookie = indexOf < this.lastBookieIndex() ? indexOf + 1 : indexOf - 1;
        this.shutdownBookie(this.serverByIndex(bkIndexDownBookie));
        this.startNewBookie();
        this.startNewBookie();
        BookieServer newAuditor = this.waitForNewAuditor(auditor);
        AssertJUnit.assertSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor);
    }

    @Test
    public void testSuccessiveAuditorCrashes() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        this.shutdownBookie(auditor);
        BookieServer newAuditor1 = this.waitForNewAuditor(auditor);
        this.shutdownBookie(newAuditor1);
        BookieServer newAuditor2 = this.waitForNewAuditor(newAuditor1);
        AssertJUnit.assertNotSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor2);
    }

    @Test
    public void testBookieClusterRestart() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        for (AuditorElector auditorElector : this.auditorElectors.values()) {
            AssertJUnit.assertTrue((String)"Auditor elector is not running!", (boolean)auditorElector.isRunning());
        }
        this.stopBKCluster();
        this.stopAuditorElectors();
        this.startBKCluster(this.zkUtil.getMetadataServiceUri());
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        this.startAuditorElectors();
        BookieServer newAuditor = this.waitForNewAuditor(auditor);
        AssertJUnit.assertNotSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor);
    }

    @Test
    public void testShutdown() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        this.shutdownBookie(auditor);
        BookieServer newAuditor = this.waitForNewAuditor(auditor);
        AssertJUnit.assertNotSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor);
        List children = this.zkc.getChildren(this.electionPath, false);
        for (String child : children) {
            byte[] data = this.zkc.getData(this.electionPath + "/" + child, false, null);
            String bookieIP = new String(data);
            String addr = auditor.getBookieId().toString();
            AssertJUnit.assertFalse((String)"AuditorElection cleanup fails", (boolean)bookieIP.contains(addr));
        }
    }

    @Test
    public void testRestartAuditorBookieAfterCrashing() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        String addr = auditor.getBookieId().toString();
        ServerConfiguration serverConfiguration = this.shutdownBookie(auditor);
        this.auditorElectors.remove(addr);
        this.startBookie(serverConfiguration);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing Auditor Election:" + addr);
        }
        this.startAuditorElector(addr);
        BookieServer newAuditor = this.waitForNewAuditor(auditor);
        AssertJUnit.assertNotSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor);
        AssertJUnit.assertFalse((String)"No relection after old auditor rejoins", (boolean)auditor.getBookieId().equals((Object)newAuditor.getBookieId()));
    }

    private void startAuditorElector(String addr) throws Exception {
        AuditorElector auditorElector = new AuditorElector(addr, this.baseConf);
        this.auditorElectors.put(addr, auditorElector);
        auditorElector.start();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting Auditor Elector");
        }
    }

    private void startAuditorElectors() throws Exception {
        for (BookieId addr : this.bookieAddresses()) {
            this.startAuditorElector(addr.toString());
        }
    }

    private void stopAuditorElectors() throws Exception {
        for (AuditorElector auditorElector : this.auditorElectors.values()) {
            auditorElector.shutdown();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Stopping Auditor Elector!");
        }
    }

    private BookieServer verifyAuditor() throws Exception {
        List<BookieServer> auditors = this.getAuditorBookie();
        AssertJUnit.assertEquals((String)"Multiple Bookies acting as Auditor!", (int)1, (int)auditors.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bookie running as Auditor:" + auditors.get(0));
        }
        return auditors.get(0);
    }

    private List<BookieServer> getAuditorBookie() throws Exception {
        LinkedList<BookieServer> auditors = new LinkedList<BookieServer>();
        byte[] data = this.zkc.getData(this.electionPath, false, null);
        AssertJUnit.assertNotNull((String)"Auditor election failed", (Object)data);
        for (int i = 0; i < this.bookieCount(); ++i) {
            BookieServer bks = this.serverByIndex(i);
            if (!new String(data).contains("" + bks.getBookieId())) continue;
            auditors.add(bks);
        }
        return auditors;
    }

    private ServerConfiguration shutdownBookie(BookieServer bkServer) throws Exception {
        int index = this.indexOfServer(bkServer);
        String addr = this.addressByIndex(index).toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down bookie:" + addr);
        }
        ServerConfiguration conf = this.killBookie(index);
        this.auditorElectors.get(addr).shutdown();
        return conf;
    }

    private BookieServer waitForNewAuditor(BookieServer auditor) throws Exception {
        BookieServer newAuditor = null;
        for (int retryCount = 8; retryCount > 0; --retryCount) {
            try {
                List<BookieServer> auditors = this.getAuditorBookie();
                if (auditors.size() > 0 && auditor != (newAuditor = auditors.get(0))) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.sleep(500L);
        }
        AssertJUnit.assertNotNull((String)"New Auditor is not reelected after auditor crashes", newAuditor);
        this.verifyAuditor();
        return newAuditor;
    }
}

