/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.replication.BookKeeperClusterTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuditorPeriodicBookieCheckTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorPeriodicBookieCheckTest.class);
    private AuditorElector auditorElector = null;
    private static final int CHECK_INTERVAL = 1;

    public AuditorPeriodicBookieCheckTest() throws Exception {
        super(3);
        this.baseConf.setPageLimit(1);
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver");
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver");
    }

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setAuditorPeriodicBookieCheckInterval(1L);
        conf.setMetadataServiceUri(this.metadataServiceUri.replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        conf.setProperty("clientConnectTimeoutMillis", (Object)500);
        String addr = this.addressByIndex(0).toString();
        this.auditorElector = new AuditorElector(addr, conf);
        this.auditorElector.start();
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        this.auditorElector.shutdown();
        super.tearDown();
    }

    @Test
    public void testPeriodicBookieCheckInterval() throws Exception {
        this.confByIndex(0).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)this.confByIndex(0), mFactory -> {
            try (LedgerManager ledgerManager = mFactory.newLedgerManager();){
                LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
                try {
                    long ledgerId = 12345L;
                    ClientUtil.setupLedger((LedgerManager)this.bkc.getLedgerManager(), (long)ledgerId, (LedgerMetadataBuilder)LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 1000).toBookieId(), this.getBookie(0), this.getBookie(1)})));
                    long underReplicatedLedger = -1L;
                    for (int i = 0; i < 10 && (underReplicatedLedger = underReplicationManager.pollLedgerToRereplicate()) == -1L; ++i) {
                        Thread.sleep(1000L);
                    }
                    AssertJUnit.assertEquals((String)"Ledger should be under replicated", (long)ledgerId, (long)underReplicatedLedger);
                }
                finally {
                    if (Collections.singletonList(underReplicationManager).get(0) != null) {
                        underReplicationManager.close();
                    }
                }
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }
}

