/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.LinkedList;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.replication.AuditorReplicasCheckTask;
import org.apache.bookkeeper.replication.AuditorStats;
import org.apache.bookkeeper.replication.BookKeeperClusterTestCase;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuditorReplicasCheckTaskTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorReplicasCheckTaskTest.class);
    private BookKeeperAdmin admin;
    private LedgerManager ledgerManager;
    private LedgerUnderreplicationManager ledgerUnderreplicationManager;

    public AuditorReplicasCheckTaskTest() throws Exception {
        super(3);
        this.baseConf.setPageLimit(1);
        this.baseConf.setAutoRecoveryDaemonEnabled(false);
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver");
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver");
    }

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.baseClientConf.setMetadataServiceUri(this.metadataServiceUri.replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        BookKeeper bookKeeper = this.registerCloseable(new BookKeeper(this.baseClientConf));
        this.admin = new BookKeeperAdmin(bookKeeper, (StatsLogger)NullStatsLogger.INSTANCE, new ClientConfiguration((AbstractConfiguration)this.baseClientConf));
        LedgerManagerFactory ledgerManagerFactory = this.registerCloseable(bookKeeper.getLedgerManagerFactory());
        this.ledgerManager = ledgerManagerFactory.newLedgerManager();
        this.ledgerUnderreplicationManager = ledgerManagerFactory.newLedgerUnderreplicationManager();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.ledgerManager != null) {
            this.ledgerManager.close();
        }
        if (this.ledgerUnderreplicationManager != null) {
            this.ledgerUnderreplicationManager.close();
        }
        if (this.admin != null) {
            this.admin.close();
        }
        super.tearDown();
    }

    @Test
    public void testReplicasCheck() throws BKException, InterruptedException {
        int numLedgers = 10;
        LinkedList<Long> ids = new LinkedList<Long>();
        for (int i = 0; i < 10; ++i) {
            LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, "passwd".getBytes());
            ids.add(lh.getId());
            for (int j = 0; j < 2; ++j) {
                lh.addEntry("testdata".getBytes());
            }
            lh.close();
        }
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("auditor");
        AuditorStats auditorStats = new AuditorStats((StatsLogger)statsLogger);
        AuditorReplicasCheckTask auditorReplicasCheckTask = new AuditorReplicasCheckTask(this.baseConf, auditorStats, this.admin, this.ledgerManager, this.ledgerUnderreplicationManager, null, (flag, throwable) -> flag.set(false));
        auditorReplicasCheckTask.runTask();
        AssertJUnit.assertEquals((String)"REPLICAS_CHECK_TIME", (long)1L, (long)((TestStatsProvider.TestOpStatsLogger)statsLogger.getOpStatsLogger("REPLICAS_CHECK_TIME")).getSuccessCount());
    }
}

