/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.replication.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestCallbacks;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuditorRollingRestartTest
extends BookKeeperClusterTestCase {
    public AuditorRollingRestartTest() throws Exception {
        super(3, 600);
        this.setAutoRecoveryEnabled(true);
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver");
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver");
    }

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void startBKCluster(String metadataServiceUri) throws Exception {
        super.startBKCluster(metadataServiceUri.replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
    }

    @Test
    public void testAuditingDuringRollingRestart() throws Exception {
        this.confByIndex(0).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)this.confByIndex(0), mFactory -> {
            try {
                this.testAuditingDuringRollingRestart((LedgerManagerFactory)mFactory);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAuditingDuringRollingRestart(LedgerManagerFactory mFactory) throws Exception {
        LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, "passwd".getBytes());
        for (int i = 0; i < 10; ++i) {
            lh.asyncAddEntry("foobar".getBytes(), (AsyncCallback.AddCallback)new TestCallbacks.AddCallbackFuture((long)i), null);
        }
        lh.addEntry("foobar".getBytes());
        lh.close();
        AssertJUnit.assertEquals((String)"shouldn't be anything under replicated", (long)underReplicationManager.pollLedgerToRereplicate(), (long)-1L);
        underReplicationManager.disableLedgerReplication();
        LedgerAuditorManager lam = mFactory.newLedgerAuditorManager();
        try {
            BookieId auditor = lam.getCurrentAuditor();
            ServerConfiguration conf = this.killBookie(auditor);
            Thread.sleep(2000L);
            this.startBookie(conf);
            Thread.sleep(2000L);
            AssertJUnit.assertEquals((String)"shouldn't be anything under replicated", (long)-1L, (long)underReplicationManager.pollLedgerToRereplicate());
        }
        finally {
            if (Collections.singletonList(lam).get(0) != null) {
                lam.close();
            }
        }
    }
}

