/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.replication.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.TestUtils;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManagerFactory;
import org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.apache.zookeeper.ZooKeeper;
import org.awaitility.Awaitility;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AutoRecoveryMainTest
extends BookKeeperClusterTestCase {
    public AutoRecoveryMainTest() throws Exception {
        super(3);
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver");
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver");
    }

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testStartup() throws Exception {
        this.confByIndex(0).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        AutoRecoveryMain main = new AutoRecoveryMain(this.confByIndex(0));
        try {
            main.start();
            Thread.sleep(500L);
            AssertJUnit.assertTrue((String)"AuditorElector should be running", (boolean)main.auditorElector.isRunning());
            AssertJUnit.assertTrue((String)"Replication worker should be running", (boolean)main.replicationWorker.isRunning());
        }
        finally {
            main.shutdown();
        }
    }

    @Test
    public void testShutdown() throws Exception {
        this.confByIndex(0).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        AutoRecoveryMain main = new AutoRecoveryMain(this.confByIndex(0));
        main.start();
        Thread.sleep(500L);
        AssertJUnit.assertTrue((String)"AuditorElector should be running", (boolean)main.auditorElector.isRunning());
        AssertJUnit.assertTrue((String)"Replication worker should be running", (boolean)main.replicationWorker.isRunning());
        main.shutdown();
        AssertJUnit.assertFalse((String)"AuditorElector should not be running", (boolean)main.auditorElector.isRunning());
        AssertJUnit.assertFalse((String)"Replication worker should not be running", (boolean)main.replicationWorker.isRunning());
    }

    @Test
    public void testAutoRecoverySessionLoss() throws Exception {
        this.confByIndex(0).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        this.confByIndex(1).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        this.confByIndex(2).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        AutoRecoveryMain main1 = new AutoRecoveryMain(this.confByIndex(0));
        AutoRecoveryMain main2 = new AutoRecoveryMain(this.confByIndex(1));
        AutoRecoveryMain main3 = new AutoRecoveryMain(this.confByIndex(2));
        PulsarMetadataClientDriver pulsarMetadataClientDriver1 = this.startAutoRecoveryMain(main1);
        ZooKeeper zk1 = this.getZk(pulsarMetadataClientDriver1);
        for (int i = 0; i < 10; ++i) {
            try {
                if (main1.auditorElector.getCurrentAuditor() != null) break;
                Thread.sleep(1000L);
                continue;
            }
            catch (IOException e) {
                Thread.sleep(1000L);
            }
        }
        BookieId currentAuditor = main1.auditorElector.getCurrentAuditor();
        AssertJUnit.assertNotNull((Object)currentAuditor);
        Auditor auditor1 = main1.auditorElector.getAuditor();
        AssertJUnit.assertEquals((String)"Current Auditor should be AR1", (Object)currentAuditor, (Object)BookieImpl.getBookieId((ServerConfiguration)this.confByIndex(0)));
        Awaitility.waitAtMost((long)30L, (TimeUnit)TimeUnit.SECONDS).untilAsserted(() -> {
            AssertJUnit.assertNotNull((Object)auditor1);
            AssertJUnit.assertTrue((String)"Auditor of AR1 should be running", (boolean)auditor1.isRunning());
        });
        PulsarMetadataClientDriver pulsarMetadataClientDriver2 = this.startAutoRecoveryMain(main2);
        ZooKeeper zk2 = this.getZk(pulsarMetadataClientDriver2);
        PulsarMetadataClientDriver pulsarMetadataClientDriver3 = this.startAutoRecoveryMain(main3);
        ZooKeeper zk3 = this.getZk(pulsarMetadataClientDriver3);
        AssertJUnit.assertEquals((String)"Current Auditor should still be AR1", (Object)currentAuditor, (Object)BookieImpl.getBookieId((ServerConfiguration)this.confByIndex(0)));
        Awaitility.await().untilAsserted(() -> {
            AssertJUnit.assertTrue((String)"AR2's Auditor should not be running", (main2.auditorElector.getAuditor() == null || !main2.auditorElector.getAuditor().isRunning() ? 1 : 0) != 0);
            AssertJUnit.assertTrue((String)"AR3's Auditor should not be running", (main3.auditorElector.getAuditor() == null || !main3.auditorElector.getAuditor().isRunning() ? 1 : 0) != 0);
        });
        this.zkUtil.expireSession(zk2);
        this.zkUtil.expireSession(zk1);
        for (int i = 0; i < 10 && (main1.auditorElector.isRunning() || main1.replicationWorker.isRunning() || main1.isAutoRecoveryRunning() || main2.auditorElector.isRunning() || main2.replicationWorker.isRunning() || main2.isAutoRecoveryRunning()); ++i) {
            Thread.sleep(1000L);
        }
        currentAuditor = main3.auditorElector.getCurrentAuditor();
        AssertJUnit.assertEquals((String)"Current Auditor should be AR3", (Object)currentAuditor, (Object)BookieImpl.getBookieId((ServerConfiguration)this.confByIndex(2)));
        Awaitility.await().untilAsserted(() -> {
            AssertJUnit.assertNotNull((Object)main3.auditorElector.getAuditor());
            AssertJUnit.assertTrue((String)"Auditor of AR3 should be running", (boolean)main3.auditorElector.getAuditor().isRunning());
        });
        Awaitility.waitAtMost((long)100L, (TimeUnit)TimeUnit.SECONDS).untilAsserted(() -> {
            AssertJUnit.assertFalse((String)"AR1's auditor should not be running", (boolean)auditor1.isRunning());
            AssertJUnit.assertFalse((String)"Elector1 should have shutdown", (boolean)main1.auditorElector.isRunning());
            AssertJUnit.assertFalse((String)"RW1 should have shutdown", (boolean)main1.replicationWorker.isRunning());
            AssertJUnit.assertFalse((String)"AR1 should have shutdown", (boolean)main1.isAutoRecoveryRunning());
            AssertJUnit.assertFalse((String)"Elector2 should have shutdown", (boolean)main2.auditorElector.isRunning());
            AssertJUnit.assertFalse((String)"RW2 should have shutdown", (boolean)main2.replicationWorker.isRunning());
            AssertJUnit.assertFalse((String)"AR2 should have shutdown", (boolean)main2.isAutoRecoveryRunning());
        });
    }

    PulsarMetadataClientDriver startAutoRecoveryMain(AutoRecoveryMain autoRecoveryMain) throws Exception {
        autoRecoveryMain.start();
        PulsarMetadataClientDriver pulsarMetadataClientDriver = (PulsarMetadataClientDriver)autoRecoveryMain.bkc.getMetadataClientDriver();
        TestUtils.assertEventuallyTrue((String)"autoRecoveryMain components should be running", () -> autoRecoveryMain.auditorElector.isRunning() && autoRecoveryMain.replicationWorker.isRunning() && autoRecoveryMain.isAutoRecoveryRunning());
        return pulsarMetadataClientDriver;
    }

    private ZooKeeper getZk(PulsarMetadataClientDriver pulsarMetadataClientDriver) throws Exception {
        PulsarLedgerManagerFactory pulsarLedgerManagerFactory = (PulsarLedgerManagerFactory)pulsarMetadataClientDriver.getLedgerManagerFactory();
        Field field = pulsarLedgerManagerFactory.getClass().getDeclaredField("store");
        field.setAccessible(true);
        ZKMetadataStore zkMetadataStore = (ZKMetadataStore)field.get(pulsarLedgerManagerFactory);
        return zkMetadataStore.getZkClient();
    }
}

