/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.TestStatsProvider;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.metastore.InMemoryMetaStore;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.ReplicationWorker;
import org.apache.bookkeeper.replication.ZooKeeperUtil;
import org.apache.bookkeeper.test.ServerTester;
import org.apache.bookkeeper.test.TmpDirs;
import org.apache.bookkeeper.test.ZooKeeperCluster;
import org.apache.bookkeeper.test.ZooKeeperClusterUtil;
import org.apache.pulsar.common.util.PortManager;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.FaultInjectionMetadataStore;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;

public abstract class BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(BookKeeperClusterTestCase.class);
    protected String testName;
    protected final ZooKeeperCluster zkUtil;
    protected ZooKeeper zkc;
    protected String metadataServiceUri;
    protected FaultInjectionMetadataStore metadataStore;
    protected final TmpDirs tmpDirs = new TmpDirs();
    protected final List<ServerTester> servers = new LinkedList<ServerTester>();
    protected int numBookies;
    protected BookKeeperTestClient bkc;
    protected boolean useUUIDasBookieId = true;
    protected final ServerConfiguration baseConf = TestBKConfiguration.newServerConfiguration();
    protected final ClientConfiguration baseClientConf = TestBKConfiguration.newClientConfiguration();
    private boolean isAutoRecoveryEnabled;
    protected ExecutorService executor;
    private final List<Integer> bookiePorts = new ArrayList<Integer>();
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    SynchronousQueue<Throwable> asyncExceptions = new SynchronousQueue();

    @BeforeMethod
    public void handleTestMethodName(Method method) {
        this.testName = method.getName();
    }

    protected void captureThrowable(Runnable c) {
        try {
            c.run();
        }
        catch (Throwable e) {
            LOG.error("Captured error: ", e);
            this.asyncExceptions.add(e);
        }
    }

    public BookKeeperClusterTestCase(int numBookies) {
        this(numBookies, 120);
    }

    public BookKeeperClusterTestCase(int numBookies, int testTimeoutSecs) {
        this(numBookies, 1, testTimeoutSecs);
    }

    public BookKeeperClusterTestCase(int numBookies, int numOfZKNodes, int testTimeoutSecs) {
        this.numBookies = numBookies;
        if (numOfZKNodes == 1) {
            this.zkUtil = new ZooKeeperUtil(this.getLedgersRootPath());
        } else {
            try {
                this.zkUtil = new ZooKeeperClusterUtil(numOfZKNodes);
            }
            catch (IOException | InterruptedException | KeeperException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @BeforeTest
    public void setUp() throws Exception {
        this.setUp(this.getLedgersRootPath());
    }

    protected void setUp(String ledgersRootPath) throws Exception {
        LOG.info("Setting up test {}", this.getClass());
        InMemoryMetaStore.reset();
        this.setMetastoreImplClass((AbstractConfiguration)this.baseConf);
        this.setMetastoreImplClass((AbstractConfiguration)this.baseClientConf);
        this.executor = Executors.newCachedThreadPool();
        Stopwatch sw = Stopwatch.createStarted();
        try {
            this.startZKCluster();
            this.metadataServiceUri = this.getMetadataServiceUri(ledgersRootPath);
            this.startBKCluster(this.metadataServiceUri);
            LOG.info("Setup testcase {} @ metadata service {} in {} ms.", new Object[]{this.testName, this.metadataServiceUri, sw.elapsed(TimeUnit.MILLISECONDS)});
        }
        catch (Exception e) {
            LOG.error("Error setting up", (Throwable)e);
            throw e;
        }
    }

    protected String getMetadataServiceUri(String ledgersRootPath) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath);
    }

    private String getLedgersRootPath() {
        return this.changeLedgerPath() + "/ledgers";
    }

    protected String changeLedgerPath() {
        return "";
    }

    @AfterTest(alwaysRun=true)
    public void tearDown() throws Exception {
        BookKeeperClusterTestCase.callCloseables(this.closeables);
        this.closeables.clear();
        boolean failed = false;
        for (Throwable e : this.asyncExceptions) {
            LOG.error("Got async exception: ", e);
            failed = true;
        }
        Assert.assertFalse((boolean)failed, (String)"Async failure");
        Stopwatch sw = Stopwatch.createStarted();
        LOG.info("TearDown");
        Exception tearDownException = null;
        try {
            this.stopBKCluster();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to stop BKCluster", (Throwable)e);
            tearDownException = e;
        }
        try {
            this.metadataStore.close();
            this.stopZKCluster();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to stop ZKCluster", (Throwable)e);
            tearDownException = e;
        }
        try {
            this.tmpDirs.cleanup();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to cleanupTempDirs", (Throwable)e);
            tearDownException = e;
        }
        this.executor.shutdownNow();
        LOG.info("Tearing down test {} in {} ms.", (Object)this.testName, (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        if (tearDownException != null) {
            throw tearDownException;
        }
    }

    protected <T extends AutoCloseable> T registerCloseable(T closeable) {
        this.closeables.add(closeable);
        return closeable;
    }

    private static void callCloseables(List<AutoCloseable> closeables) {
        for (int i = closeables.size() - 1; i >= 0; --i) {
            try {
                closeables.get(i).close();
                continue;
            }
            catch (Exception e) {
                LOG.error("Failure in calling close method", (Throwable)e);
            }
        }
    }

    protected void startZKCluster() throws Exception {
        this.zkUtil.startCluster();
        this.zkc = this.zkUtil.getZooKeeperClient();
        this.metadataStore = new FaultInjectionMetadataStore(MetadataStoreExtended.create((String)this.zkUtil.getZooKeeperConnectString(), (MetadataStoreConfig)MetadataStoreConfig.builder().metadataStoreName("metastore-" + this.getClass().getSimpleName()).build()));
    }

    protected void stopZKCluster() throws Exception {
        this.zkUtil.killCluster();
    }

    protected void startBKCluster(String metadataServiceUri) throws Exception {
        this.baseConf.setMetadataServiceUri(metadataServiceUri);
        this.baseClientConf.setMetadataServiceUri(metadataServiceUri);
        this.baseClientConf.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        if (this.numBookies > 0) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        for (int i = 0; i < this.numBookies; ++i) {
            this.bookiePorts.add(this.startNewBookie());
        }
    }

    protected void stopBKCluster() throws Exception {
        if (this.bkc != null) {
            this.bkc.close();
        }
        for (ServerTester t : this.servers) {
            t.shutdown();
        }
        this.servers.clear();
        this.bookiePorts.removeIf(PortManager::releaseLockedPort);
    }

    protected ServerConfiguration newServerConfiguration() throws Exception {
        File f = this.tmpDirs.createNew("bookie", "test");
        int port = this.baseConf.isEnableLocalTransport() || !this.baseConf.getAllowEphemeralPorts() ? PortManager.nextLockedFreePort() : 0;
        return this.newServerConfiguration(port, f, new File[]{f});
    }

    protected ClientConfiguration newClientConfiguration() {
        return new ClientConfiguration((AbstractConfiguration)this.baseConf);
    }

    protected ServerConfiguration newServerConfiguration(int port, File journalDir, File[] ledgerDirs) {
        ServerConfiguration conf = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        conf.setBookiePort(port);
        conf.setJournalDirName(journalDir.getPath());
        String[] ledgerDirNames = new String[ledgerDirs.length];
        for (int i = 0; i < ledgerDirs.length; ++i) {
            ledgerDirNames[i] = ledgerDirs[i].getPath();
        }
        conf.setLedgerDirNames(ledgerDirNames);
        conf.setEnableTaskExecutionStats(true);
        conf.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        return conf;
    }

    protected void stopAllBookies() throws Exception {
        this.stopAllBookies(true);
    }

    protected void stopAllBookies(boolean shutdownClient) throws Exception {
        for (ServerTester t : this.servers) {
            t.shutdown();
        }
        this.servers.clear();
        if (shutdownClient && this.bkc != null) {
            this.bkc.close();
            this.bkc = null;
        }
    }

    protected String newMetadataServiceUri(String ledgersRootPath) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath);
    }

    protected String newMetadataServiceUri(String ledgersRootPath, String type) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath, type);
    }

    public BookieId getBookie(int index) throws Exception {
        return this.servers.get(index).getServer().getBookieId();
    }

    protected List<BookieId> bookieAddresses() throws Exception {
        ArrayList<BookieId> bookieIds = new ArrayList<BookieId>();
        for (ServerTester a : this.servers) {
            bookieIds.add(a.getServer().getBookieId());
        }
        return bookieIds;
    }

    protected List<File> bookieLedgerDirs() throws Exception {
        return this.servers.stream().flatMap(t -> Arrays.stream(t.getConfiguration().getLedgerDirs())).collect(Collectors.toList());
    }

    protected List<File> bookieJournalDirs() throws Exception {
        return this.servers.stream().flatMap(t -> Arrays.stream(t.getConfiguration().getJournalDirs())).collect(Collectors.toList());
    }

    protected BookieId addressByIndex(int index) throws Exception {
        return this.servers.get(index).getServer().getBookieId();
    }

    protected BookieServer serverByIndex(int index) throws Exception {
        return this.servers.get(index).getServer();
    }

    protected ServerConfiguration confByIndex(int index) throws Exception {
        return this.servers.get(index).getConfiguration();
    }

    private Optional<ServerTester> byAddress(BookieId addr) throws UnknownHostException {
        for (ServerTester s : this.servers) {
            if (!s.getServer().getBookieId().equals((Object)addr)) continue;
            return Optional.of(s);
        }
        return Optional.empty();
    }

    protected int indexOfServer(BookieServer b) throws Exception {
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!this.servers.get(i).getServer().equals(b)) continue;
            return i;
        }
        return -1;
    }

    protected int lastBookieIndex() {
        return this.servers.size() - 1;
    }

    protected int bookieCount() {
        return this.servers.size();
    }

    private OptionalInt indexByAddress(BookieId addr) throws UnknownHostException {
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!addr.equals((Object)this.servers.get(i).getServer().getBookieId())) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public ServerConfiguration getBkConf(BookieId addr) throws Exception {
        return this.byAddress(addr).get().getConfiguration();
    }

    public ServerConfiguration killBookie(BookieId addr) throws Exception {
        Optional<ServerTester> tester = this.byAddress(addr);
        if (tester.isPresent()) {
            if (tester.get().autoRecovery != null && tester.get().autoRecovery.getAuditor() != null && tester.get().autoRecovery.getAuditor().isRunning()) {
                LOG.warn("Killing bookie {} who is the current Auditor", (Object)addr);
            }
            this.servers.remove(tester.get());
            tester.get().shutdown();
            return tester.get().getConfiguration();
        }
        return null;
    }

    public void setBookieToReadOnly(BookieId addr) throws Exception {
        Optional<ServerTester> tester = this.byAddress(addr);
        if (tester.isPresent()) {
            tester.get().getServer().getBookie().getStateManager().transitionToReadOnlyMode().get();
        }
    }

    public ServerConfiguration killBookie(int index) throws Exception {
        ServerTester tester = this.servers.remove(index);
        tester.shutdown();
        return tester.getConfiguration();
    }

    public ServerConfiguration killBookieAndWaitForZK(int index) throws Exception {
        ServerTester tester = this.servers.get(index);
        ServerConfiguration ret = this.killBookie(index);
        while (this.zkc.exists("/ledgers/available/" + tester.getServer().getBookieId().toString(), false) != null) {
            Thread.sleep(500L);
        }
        return ret;
    }

    public CountDownLatch sleepBookie(BookieId addr, final int seconds) throws Exception {
        final Optional<ServerTester> tester = this.byAddress(addr);
        if (tester.isPresent()) {
            final CountDownLatch latch = new CountDownLatch(1);
            Thread sleeper = new Thread(){

                @Override
                public void run() {
                    try {
                        ((ServerTester)tester.get()).getServer().suspendProcessing();
                        LOG.info("bookie {} is asleep", (Object)((ServerTester)tester.get()).getAddress());
                        latch.countDown();
                        Thread.sleep(seconds * 1000);
                        ((ServerTester)tester.get()).getServer().resumeProcessing();
                        LOG.info("bookie {} is awake", (Object)((ServerTester)tester.get()).getAddress());
                    }
                    catch (Exception e) {
                        LOG.error("Error suspending bookie", (Throwable)e);
                    }
                }
            };
            sleeper.start();
            return latch;
        }
        throw new IOException("Bookie not found");
    }

    public void sleepBookie(BookieId addr, CountDownLatch l) throws InterruptedException, IOException {
        CountDownLatch suspendLatch = new CountDownLatch(1);
        this.sleepBookie(addr, l, suspendLatch);
        suspendLatch.await();
    }

    public void sleepBookie(BookieId addr, final CountDownLatch l, final CountDownLatch suspendLatch) throws InterruptedException, IOException {
        Optional<ServerTester> tester = this.byAddress(addr);
        if (!tester.isPresent()) {
            throw new IOException("Bookie not found");
        }
        final BookieServer bookie = tester.get().getServer();
        LOG.info("Sleep bookie {}.", (Object)addr);
        Thread sleeper = new Thread(){

            @Override
            public void run() {
                try {
                    bookie.suspendProcessing();
                    if (null != suspendLatch) {
                        suspendLatch.countDown();
                    }
                    l.await();
                    bookie.resumeProcessing();
                }
                catch (Exception e) {
                    LOG.error("Error suspending bookie", (Throwable)e);
                }
            }
        };
        sleeper.start();
    }

    public void restartBookies() throws Exception {
        this.restartBookies(c -> c);
    }

    public void restartBookie(BookieId addr) throws Exception {
        OptionalInt toRemove = this.indexByAddress(addr);
        if (!toRemove.isPresent()) {
            throw new IOException("Bookie not found");
        }
        ServerConfiguration newConfig = this.killBookie(toRemove.getAsInt());
        Thread.sleep(1000L);
        this.startAndAddBookie(newConfig);
    }

    public void restartBookies(Function<ServerConfiguration, ServerConfiguration> reconfFunction) throws Exception {
        ArrayList<ServerConfiguration> confs = new ArrayList<ServerConfiguration>();
        for (ServerTester server : this.servers) {
            server.shutdown();
            confs.add(server.getConfiguration());
        }
        this.servers.clear();
        Thread.sleep(1000L);
        for (ServerConfiguration conf : confs) {
            this.startAndAddBookie(reconfFunction.apply(conf));
        }
    }

    public int startNewBookie() throws Exception {
        return this.startNewBookieAndReturnAddress().getPort();
    }

    public BookieSocketAddress startNewBookieAndReturnAddress() throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        LOG.info("Starting new bookie on port: {}", (Object)conf.getBookiePort());
        return this.startAndAddBookie(conf).getServer().getLocalAddress();
    }

    public BookieId startNewBookieAndReturnBookieId() throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        LOG.info("Starting new bookie on port: {}", (Object)conf.getBookiePort());
        return this.startAndAddBookie(conf).getServer().getBookieId();
    }

    protected ServerTester startAndAddBookie(ServerConfiguration conf) throws Exception {
        ServerTester server = this.startBookie(conf);
        this.servers.add(server);
        return server;
    }

    protected ServerTester startAndAddBookie(ServerConfiguration conf, Bookie b) throws Exception {
        ServerTester server = this.startBookie(conf, b);
        this.servers.add(server);
        return server;
    }

    protected ServerTester startBookie(ServerConfiguration conf) throws Exception {
        ServerTester tester = new ServerTester(conf);
        if (this.bkc == null) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        BookieId address = tester.getServer().getBookieId();
        Future waitForBookie = conf.isForceReadOnlyBookie() ? this.bkc.waitForReadOnlyBookie(address) : this.bkc.waitForWritableBookie(address);
        tester.getServer().start();
        waitForBookie.get(30L, TimeUnit.SECONDS);
        LOG.info("New bookie '{}' has been created.", (Object)address);
        if (this.isAutoRecoveryEnabled()) {
            tester.startAutoRecovery();
        }
        int port = conf.getBookiePort();
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> {
            while (this.zkc.exists("/ledgers/available/" + tester.getServer().getBookieId().toString(), false) == null) {
                Thread.sleep(100L);
            }
            return true;
        });
        this.bkc.readBookiesBlocking();
        LOG.info("New bookie on port " + port + " has been created.");
        return tester;
    }

    protected ServerTester startBookie(ServerConfiguration conf, Bookie b) throws Exception {
        ServerTester tester = new ServerTester(conf, b);
        if (this.bkc == null) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        BookieId address = tester.getServer().getBookieId();
        Future waitForBookie = conf.isForceReadOnlyBookie() ? this.bkc.waitForReadOnlyBookie(address) : this.bkc.waitForWritableBookie(address);
        tester.getServer().start();
        waitForBookie.get(30L, TimeUnit.SECONDS);
        if (this.isAutoRecoveryEnabled()) {
            tester.startAutoRecovery();
        }
        int port = conf.getBookiePort();
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> (Boolean)this.metadataStore.exists(this.getLedgersRootPath() + "/available/" + address).join());
        this.bkc.readBookiesBlocking();
        LOG.info("New bookie '{}' has been created.", (Object)address);
        return tester;
    }

    public void setMetastoreImplClass(AbstractConfiguration conf) {
        conf.setMetastoreImplClass(InMemoryMetaStore.class.getName());
    }

    public void setAutoRecoveryEnabled(boolean isAutoRecoveryEnabled) {
        this.isAutoRecoveryEnabled = isAutoRecoveryEnabled;
    }

    public boolean isAutoRecoveryEnabled() {
        return this.isAutoRecoveryEnabled;
    }

    public void startReplicationService() throws Exception {
        for (ServerTester t : this.servers) {
            t.startAutoRecovery();
        }
    }

    public void stopReplicationService() throws Exception {
        for (ServerTester t : this.servers) {
            t.stopAutoRecovery();
        }
    }

    public Auditor getAuditor(int timeout, TimeUnit unit) throws Exception {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
        while (System.nanoTime() < timeoutAt) {
            for (ServerTester t : this.servers) {
                Auditor a = t.getAuditor();
                ReplicationWorker replicationWorker = t.getReplicationWorker();
                if (a != null && a.isRunning() && replicationWorker != null && replicationWorker.isRunning()) {
                    int deathWatchInterval = t.getConfiguration().getDeathWatchInterval();
                    Thread.sleep(deathWatchInterval + 1000);
                }
                if (a == null || !a.isRunning() || replicationWorker == null || !replicationWorker.isRunning()) continue;
                LOG.info("Found Auditor Bookie {}", (Object)t.getServer().getBookieId());
                return a;
            }
            Thread.sleep(100L);
        }
        throw new Exception("No auditor found");
    }

    public boolean isCreatedFromIp(BookieId bookieId) {
        BookieSocketAddress addr = this.bkc.getBookieAddressResolver().resolve(bookieId);
        return addr.getSocketAddress().toString().startsWith("/");
    }

    public void resetBookieOpLoggers() {
        this.servers.forEach(t -> t.getStatsProvider().clear());
    }

    public TestStatsProvider getStatsProvider(BookieId addr) throws UnknownHostException {
        return this.byAddress(addr).get().getStatsProvider();
    }

    public TestStatsProvider getStatsProvider(int index) throws Exception {
        return this.servers.get(index).getStatsProvider();
    }
}

