/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.replication.BookKeeperClusterTestCase;
import org.apache.bookkeeper.replication.BookieLedgerIndexer;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarLayoutManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BookieLedgerIndexTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookieLedgerIndexTest.class);
    private Random rng;
    private ArrayList<byte[]> entries;
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private int numberOfLedgers = 3;
    private List<Long> ledgerList;
    private LedgerManagerFactory newLedgerManagerFactory;
    private LedgerManager ledgerManager;

    public BookieLedgerIndexTest() throws Exception {
        this("org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManagerFactory");
    }

    BookieLedgerIndexTest(String ledgerManagerFactory) throws Exception {
        super(3);
        LOG.info("Running test case using ledger manager : " + ledgerManagerFactory);
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver");
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver");
    }

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri().replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
        this.rng = new Random(System.currentTimeMillis());
        this.entries = new ArrayList();
        this.ledgerList = new ArrayList<Long>(3);
        String ledgersRoot = "/ledgers";
        String storeUri = this.metadataServiceUri.replaceAll("zk://", "").replaceAll("/ledgers", "");
        MetadataStoreExtended store = this.registerCloseable(MetadataStoreExtended.create((String)storeUri, (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build()));
        PulsarLayoutManager layoutManager = new PulsarLayoutManager(store, ledgersRoot);
        this.newLedgerManagerFactory = new PulsarLedgerManagerFactory();
        ClientConfiguration conf = new ClientConfiguration();
        conf.setZkLedgersRootPath(ledgersRoot);
        this.newLedgerManagerFactory.initialize((AbstractConfiguration)conf, (LayoutManager)layoutManager, 1);
        this.ledgerManager = this.newLedgerManagerFactory.newLedgerManager();
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        super.tearDown();
        if (null != this.newLedgerManagerFactory) {
            this.newLedgerManagerFactory.close();
            this.newLedgerManagerFactory = null;
        }
        if (null != this.ledgerManager) {
            this.ledgerManager.close();
            this.ledgerManager = null;
        }
    }

    @Test
    public void testSimpleBookieLedgerMapping() throws Exception {
        for (int i = 0; i < this.numberOfLedgers; ++i) {
            this.createAndAddEntriesToLedger().close();
        }
        BookieLedgerIndexer bookieLedgerIndex = new BookieLedgerIndexer(this.ledgerManager);
        Map bookieToLedgerIndex = bookieLedgerIndex.getBookieToLedgerIndex();
        AssertJUnit.assertEquals((String)"Missed few bookies in the bookie-ledger mapping!", (int)3, (int)bookieToLedgerIndex.size());
        Collection bk2ledgerEntry = bookieToLedgerIndex.values();
        for (Set ledgers : bk2ledgerEntry) {
            AssertJUnit.assertEquals((String)"Missed few ledgers in the bookie-ledger mapping!", (int)3, (int)ledgers.size());
            for (Long ledgerId : ledgers) {
                AssertJUnit.assertTrue((String)"Unknown ledger-bookie mapping", (boolean)this.ledgerList.contains(ledgerId));
            }
        }
    }

    @Test
    public void testEnsembleReformation() throws Exception {
        try {
            LedgerHandle lh1 = this.createAndAddEntriesToLedger();
            LedgerHandle lh2 = this.createAndAddEntriesToLedger();
            this.startNewBookie();
            this.shutdownBookie(this.lastBookieIndex() - 1);
            for (int i = 0; i < 10; ++i) {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(Integer.MAX_VALUE));
                entry.position(0);
                this.entries.add(entry.array());
                lh1.addEntry(entry.array());
                lh2.addEntry(entry.array());
            }
            BookieLedgerIndexer bookieLedgerIndex = new BookieLedgerIndexer(this.ledgerManager);
            Map bookieToLedgerIndex = bookieLedgerIndex.getBookieToLedgerIndex();
            AssertJUnit.assertEquals((String)"Missed few bookies in the bookie-ledger mapping!", (int)4, (int)bookieToLedgerIndex.size());
            Collection bk2ledgerEntry = bookieToLedgerIndex.values();
            for (Set ledgers : bk2ledgerEntry) {
                AssertJUnit.assertEquals((String)"Missed few ledgers in the bookie-ledger mapping!", (int)2, (int)ledgers.size());
                for (Long ledgerNode : ledgers) {
                    AssertJUnit.assertTrue((String)"Unknown ledger-bookie mapping", (boolean)this.ledgerList.contains(ledgerNode));
                }
            }
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            AssertJUnit.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            AssertJUnit.fail((String)"Test failed due to interruption");
        }
    }

    private void shutdownBookie(int bkShutdownIndex) throws Exception {
        this.killBookie(bkShutdownIndex);
    }

    private LedgerHandle createAndAddEntriesToLedger() throws BKException, InterruptedException {
        int numEntriesToWrite = 20;
        LedgerHandle lh = this.bkc.createLedger(this.digestType, "admin".getBytes());
        LOG.info("Ledger ID: " + lh.getId());
        for (int i = 0; i < numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(Integer.MAX_VALUE));
            entry.position(0);
            this.entries.add(entry.array());
            lh.addEntry(entry.array());
        }
        this.ledgerList.add(lh.getId());
        return lh;
    }
}

