/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class ReplicationTestUtil {
    public static boolean isLedgerInUnderReplication(ZooKeeper zkc, long id, String basePath) throws KeeperException, InterruptedException {
        List children;
        try {
            children = zkc.getChildren(basePath, true);
        }
        catch (KeeperException.NoNodeException nne) {
            return false;
        }
        boolean isMatched = false;
        for (String child : children) {
            if (child.startsWith("urL") && child.contains(String.valueOf(id))) {
                isMatched = true;
                break;
            }
            String path = basePath + "/" + child;
            try {
                if (zkc.getChildren(path, false).size() <= 0) continue;
                isMatched = ReplicationTestUtil.isLedgerInUnderReplication(zkc, id, path);
            }
            catch (KeeperException.NoNodeException nne) {
                return false;
            }
        }
        return isMatched;
    }
}

