/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.replication.BookKeeperClusterTestCase;
import org.apache.bookkeeper.replication.ReplicationTestUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestAutoRecoveryAlongWithBookieServers
extends BookKeeperClusterTestCase {
    private String basePath = "";

    public TestAutoRecoveryAlongWithBookieServers() throws Exception {
        super(3);
        this.setAutoRecoveryEnabled(true);
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver");
        Class.forName("org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver");
    }

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.basePath = "/ledgers/underreplication/ledgers";
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void startBKCluster(String metadataServiceUri) throws Exception {
        super.startBKCluster(metadataServiceUri.replaceAll("zk://", "metadata-store:").replaceAll("/ledgers", ""));
    }

    @Test
    public void testAutoRecoveryAlongWithBookieServers() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testpasswd".getBytes());
        byte[] testData = "testBuiltAutoRecovery".getBytes();
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(testData);
        }
        lh.close();
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        this.killBookie(replicaToKill);
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
            Thread.sleep(100L);
        }
        for (Map.Entry entry : lh.getLedgerMetadata().getAllEnsembles().entrySet()) {
            List bookies = (List)entry.getValue();
            for (BookieId bookie : bookies) {
                if (bookie.equals((Object)newBkAddr)) continue;
                this.killBookie(bookie);
            }
        }
        LedgerHandle lhs = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, "testpasswd".getBytes());
        Enumeration entries = lhs.readEntries(0L, 9L);
        AssertJUnit.assertTrue((String)"Should have the elements", (boolean)entries.hasMoreElements());
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            AssertJUnit.assertEquals((String)"testBuiltAutoRecovery", (String)new String(entry.getEntry()));
        }
    }
}

