/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.coordination.LeaderElection;
import org.apache.pulsar.metadata.api.coordination.LeaderElectionState;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.coordination.impl.CoordinationServiceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LeaderElectionTest
extends BaseMetadataStoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void basicTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            CoordinationServiceImpl coordinationService = new CoordinationServiceImpl(store);
            try {
                MetadataCache cache = store.getMetadataCache(String.class);
                LinkedBlockingDeque notifications = new LinkedBlockingDeque();
                LeaderElection leaderElection = coordinationService.getLeaderElection(String.class, "/my/leader-election", t -> notifications.add(t));
                try {
                    Assert.assertEquals(cache.get("/my/leader-election").join(), Optional.empty());
                    LeaderElectionState les = (LeaderElectionState)leaderElection.elect((Object)"test-1").join();
                    Assert.assertEquals((Object)les, (Object)LeaderElectionState.Leading);
                    Assert.assertEquals(notifications.poll(3L, TimeUnit.SECONDS), (Object)LeaderElectionState.Leading);
                    Assert.assertEquals(cache.get("/my/leader-election").join(), Optional.of("test-1"));
                    leaderElection.close();
                    Assert.assertEquals(cache.get("/my/leader-election").join(), Optional.empty());
                }
                finally {
                    if (Collections.singletonList(leaderElection).get(0) != null) {
                        leaderElection.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(coordinationService).get(0) != null) {
                    coordinationService.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void multipleMembers(String provider, Supplier<String> urlSupplier) throws Exception {
        if (provider.equals("Memory") || provider.equals("RocksDB")) {
            return;
        }
        MetadataStoreExtended store1 = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataStoreExtended store2 = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
            try {
                CoordinationServiceImpl cs1 = new CoordinationServiceImpl(store1);
                try {
                    LinkedBlockingDeque n1 = new LinkedBlockingDeque();
                    LeaderElection le1 = cs1.getLeaderElection(String.class, "/my/leader-election", t -> n1.add(t));
                    try {
                        CoordinationServiceImpl cs2 = new CoordinationServiceImpl(store2);
                        try {
                            LinkedBlockingDeque n2 = new LinkedBlockingDeque();
                            LeaderElection le2 = cs2.getLeaderElection(String.class, "/my/leader-election", t -> n2.add(t));
                            try {
                                LeaderElectionState les1 = (LeaderElectionState)le1.elect((Object)"test-1").join();
                                Assert.assertEquals((Object)les1, (Object)LeaderElectionState.Leading);
                                LeaderElectionTest.assertEqualsAndRetry(() -> le1.getLeaderValueIfPresent(), Optional.of("test-1"), Optional.empty());
                                Assert.assertEquals(le1.getLeaderValue().join(), Optional.of("test-1"));
                                Assert.assertEquals(n1.poll(3L, TimeUnit.SECONDS), (Object)LeaderElectionState.Leading);
                                LeaderElectionState les2 = (LeaderElectionState)le2.elect((Object)"test-2").join();
                                Assert.assertEquals((Object)les2, (Object)LeaderElectionState.Following);
                                Assert.assertEquals(le2.getLeaderValue().join(), Optional.of("test-1"));
                                LeaderElectionTest.assertEqualsAndRetry(() -> le2.getLeaderValueIfPresent(), Optional.of("test-1"), Optional.empty());
                                Assert.assertEquals(n2.poll(3L, TimeUnit.SECONDS), (Object)LeaderElectionState.Following);
                                le1.close();
                                Assert.assertEquals(n2.poll(3L, TimeUnit.SECONDS), (Object)LeaderElectionState.Leading);
                                Assert.assertEquals((Object)le2.getState(), (Object)LeaderElectionState.Leading);
                                LeaderElectionTest.assertEqualsAndRetry(() -> le2.getLeaderValueIfPresent(), Optional.of("test-2"), Optional.empty());
                                Assert.assertEquals(le2.getLeaderValue().join(), Optional.of("test-2"));
                            }
                            finally {
                                if (Collections.singletonList(le2).get(0) != null) {
                                    le2.close();
                                }
                            }
                        }
                        finally {
                            if (Collections.singletonList(cs2).get(0) != null) {
                                cs2.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(le1).get(0) != null) {
                            le1.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(cs1).get(0) != null) {
                        cs1.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void leaderNodeIsDeletedExternally(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            CoordinationServiceImpl coordinationService = new CoordinationServiceImpl(store);
            try {
                LinkedBlockingDeque notifications = new LinkedBlockingDeque();
                LeaderElection leaderElection = coordinationService.getLeaderElection(String.class, "/my/leader-election", t -> notifications.add(t));
                try {
                    LeaderElectionState les = (LeaderElectionState)leaderElection.elect((Object)"test-1").join();
                    Assert.assertEquals((Object)les, (Object)LeaderElectionState.Leading);
                    Assert.assertEquals(notifications.poll(3L, TimeUnit.SECONDS), (Object)LeaderElectionState.Leading);
                    store.delete("/my/leader-election", Optional.empty()).join();
                    Assert.assertEquals(notifications.poll(3L, TimeUnit.SECONDS), (Object)LeaderElectionState.Leading);
                    Assert.assertEquals((Object)les, (Object)LeaderElectionState.Leading);
                }
                finally {
                    if (Collections.singletonList(leaderElection).get(0) != null) {
                        leaderElection.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(coordinationService).get(0) != null) {
                    coordinationService.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void closeAll(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            MetadataCache cache = store.getMetadataCache(String.class);
            CoordinationServiceImpl cs = new CoordinationServiceImpl(store);
            LeaderElection le1 = cs.getLeaderElection(String.class, "/my/leader-election-1", t -> {});
            LeaderElection le2 = cs.getLeaderElection(String.class, "/my/leader-election-2", t -> {});
            LeaderElectionState les1 = (LeaderElectionState)le1.elect((Object)"test-1").join();
            Assert.assertEquals((Object)les1, (Object)LeaderElectionState.Leading);
            LeaderElectionState les2 = (LeaderElectionState)le2.elect((Object)"test-2").join();
            Assert.assertEquals((Object)les2, (Object)LeaderElectionState.Leading);
            cs.close();
            Assert.assertEquals(cache.get("/my/leader-election-1").join(), Optional.empty());
            Assert.assertEquals(cache.get("/my/leader-election-2").join(), Optional.empty());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void revalidateLeaderWithinSameSession(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            String path = this.newKey();
            CoordinationServiceImpl cs = new CoordinationServiceImpl(store);
            try {
                LeaderElection le = cs.getLeaderElection(String.class, path, __ -> {});
                try {
                    store.put(path, ObjectMapperFactory.getMapper().writer().writeValueAsBytes((Object)"test-1"), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
                    LeaderElectionState les = (LeaderElectionState)le.elect((Object)"test-2").join();
                    Assert.assertEquals((Object)les, (Object)LeaderElectionState.Leading);
                    Assert.assertEquals(le.getLeaderValue().join(), Optional.of("test-2"));
                    LeaderElectionTest.assertEqualsAndRetry(() -> le.getLeaderValueIfPresent(), Optional.of("test-2"), Optional.empty());
                }
                finally {
                    if (Collections.singletonList(le).get(0) != null) {
                        le.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(cs).get(0) != null) {
                    cs.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void revalidateLeaderWithDifferentSessionsSameValue(String provider, Supplier<String> urlSupplier) throws Exception {
        if (provider.equals("Memory") || provider.equals("RocksDB")) {
            return;
        }
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataStoreExtended store2 = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
            try {
                String path = this.newKey();
                CoordinationServiceImpl cs = new CoordinationServiceImpl(store);
                try {
                    LeaderElection le = cs.getLeaderElection(String.class, path, __ -> {});
                    try {
                        store2.put(path, ObjectMapperFactory.getMapper().writer().writeValueAsBytes((Object)"test-1"), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
                        LeaderElectionState les = (LeaderElectionState)le.elect((Object)"test-1").join();
                        Assert.assertEquals((Object)les, (Object)LeaderElectionState.Leading);
                        Assert.assertEquals(le.getLeaderValue().join(), Optional.of("test-1"));
                        LeaderElectionTest.assertEqualsAndRetry(() -> le.getLeaderValueIfPresent(), Optional.of("test-1"), Optional.empty());
                    }
                    finally {
                        if (Collections.singletonList(le).get(0) != null) {
                            le.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(cs).get(0) != null) {
                        cs.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void revalidateLeaderWithDifferentSessionsDifferentValue(String provider, Supplier<String> urlSupplier) throws Exception {
        if (provider.equals("Memory") || provider.equals("RocksDB")) {
            return;
        }
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataStoreExtended store2 = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
            try {
                String path = this.newKey();
                CoordinationServiceImpl cs = new CoordinationServiceImpl(store);
                try {
                    LeaderElection le = cs.getLeaderElection(String.class, path, __ -> {});
                    try {
                        store2.put(path, ObjectMapperFactory.getMapper().writer().writeValueAsBytes((Object)"test-1"), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
                        LeaderElectionState les = (LeaderElectionState)le.elect((Object)"test-2").join();
                        Assert.assertEquals((Object)les, (Object)LeaderElectionState.Following);
                        Assert.assertEquals(le.getLeaderValue().join(), Optional.of("test-1"));
                        LeaderElectionTest.assertEqualsAndRetry(() -> le.getLeaderValueIfPresent(), Optional.of("test-1"), Optional.empty());
                    }
                    finally {
                        if (Collections.singletonList(le).get(0) != null) {
                            le.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(cs).get(0) != null) {
                        cs.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }
}

