/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataStoreBatchingTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreBatchingTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testBatchWrite(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().batchingEnabled(true).batchingMaxDelayMillis(1000).build());
        try {
            String key1 = this.newKey();
            CompletableFuture f1 = store.put(key1, new byte[0], Optional.empty());
            String key2 = this.newKey();
            CompletableFuture f2 = store.put(key2, new byte[0], Optional.empty());
            Stat s1 = (Stat)f1.join();
            Stat s2 = (Stat)f2.join();
            log.info("s1: {}", (Object)s1);
            log.info("s2: {}", (Object)s2);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testBatching(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().batchingEnabled(true).batchingMaxDelayMillis(1000).build());
        try {
            String key1 = this.newKey();
            store.put(key1, new byte[0], Optional.empty()).join();
            String key2 = this.newKey();
            CompletableFuture f1 = store.get(key1);
            CompletableFuture f2 = store.get(key2);
            Optional r1 = (Optional)f1.join();
            Optional r2 = (Optional)f2.join();
            Assert.assertTrue((boolean)r1.isPresent());
            Assert.assertFalse((boolean)r2.isPresent());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testPutVersionErrors(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().batchingEnabled(true).batchingMaxDelayMillis(1000).build());
        try {
            String key1 = this.newKey();
            CompletableFuture f1 = store.put(key1 + "/a", new byte[0], Optional.empty());
            CompletableFuture f2 = store.put(key1 + "/b", new byte[0], Optional.of(1L));
            CompletableFuture f3 = store.put(key1 + "/c", new byte[0], Optional.of(-1L));
            CompletableFuture f4 = store.delete(key1 + "/d", Optional.empty());
            Assert.assertTrue((((Stat)f1.join()).getVersion() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Stat)f1.join()).isFirstVersion());
            try {
                f2.join();
            }
            catch (CompletionException ce) {
                Assert.assertEquals(ce.getCause().getClass(), MetadataStoreException.BadVersionException.class);
            }
            Assert.assertTrue((((Stat)f3.join()).getVersion() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Stat)f3.join()).isFirstVersion());
            try {
                f4.join();
            }
            catch (CompletionException ce) {
                Assert.assertEquals(ce.getCause().getClass(), MetadataStoreException.NotFoundException.class);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testSequential(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().batchingEnabled(true).batchingMaxDelayMillis(1000).build());
        try {
            String key1 = this.newKey();
            ArrayList<CompletableFuture> putFutures = new ArrayList<CompletableFuture>();
            for (int i = 0; i < 10; ++i) {
                CompletableFuture f = store.put(key1 + "/x", new byte[0], Optional.of(-1L), EnumSet.of(CreateOption.Sequential));
                putFutures.add(f);
            }
            FutureUtil.waitForAll(putFutures).join();
            Assert.assertEquals((int)((List)store.getChildren(key1).join()).size(), (int)10);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testBigBatchSize(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().batchingEnabled(true).batchingMaxDelayMillis(1000).build());
        try {
            String key1 = this.newKey();
            int dataSize = 512000;
            byte[] payload = new byte[dataSize];
            int N = 40;
            ArrayList<CompletableFuture> putFutures = new ArrayList<CompletableFuture>();
            for (int i = 0; i < N; ++i) {
                putFutures.add(store.put(key1 + "/" + i, payload, Optional.empty()));
            }
            FutureUtil.waitForAll(putFutures).join();
            ArrayList<CompletableFuture> getFutures = new ArrayList<CompletableFuture>();
            for (int i = 0; i < N; ++i) {
                getFutures.add(store.get(key1 + "/" + i));
            }
            FutureUtil.waitForAll(getFutures).join();
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }
}

