/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataStoreExtendedTest
extends BaseMetadataStoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void sequentialKeys(String provider, Supplier<String> urlSupplier) throws Exception {
        String basePath = this.newKey();
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            Stat stat1 = (Stat)store.put(basePath, "value-1".getBytes(), Optional.of(-1L), EnumSet.of(CreateOption.Sequential)).join();
            Assert.assertNotNull((Object)stat1);
            Assert.assertTrue((stat1.getVersion() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)stat1.isFirstVersion());
            Assert.assertNotEquals((Object)stat1.getPath(), (Object)basePath);
            Assert.assertEquals((byte[])((GetResult)((Optional)store.get(stat1.getPath()).join()).get()).getValue(), (byte[])"value-1".getBytes());
            String seq1 = stat1.getPath().replace(basePath, "");
            long n1 = Long.parseLong(seq1);
            Stat stat2 = (Stat)store.put(basePath, "value-2".getBytes(), Optional.of(-1L), EnumSet.of(CreateOption.Sequential)).join();
            Assert.assertNotNull((Object)stat2);
            Assert.assertTrue((stat2.getVersion() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)stat2.isFirstVersion());
            Assert.assertNotEquals((Object)stat2.getPath(), (Object)basePath);
            Assert.assertNotEquals((Object)stat2.getPath(), (Object)stat1.getPath());
            Assert.assertEquals((byte[])((GetResult)((Optional)store.get(stat2.getPath()).join()).get()).getValue(), (byte[])"value-2".getBytes());
            String seq2 = stat2.getPath().replace(basePath, "");
            long n2 = Long.parseLong(seq2);
            Assert.assertNotEquals((Object)seq1, (Object)seq2);
            Assert.assertTrue((n1 < n2 ? 1 : 0) != 0);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }
}

