/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.assertj.core.util.Lists;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MetadataStoreTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void emptyStoreTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            Assert.assertFalse((boolean)((Boolean)store.exists("/non-existing-key").join()));
            Assert.assertFalse((boolean)((Boolean)store.exists("/non-existing-key/child").join()));
            Assert.assertFalse((boolean)((Optional)store.get("/non-existing-key").join()).isPresent());
            Assert.assertFalse((boolean)((Optional)store.get("/non-existing-key/child").join()).isPresent());
            Assert.assertEquals((Collection)((Collection)store.getChildren("/non-existing-key").join()), Collections.emptyList());
            Assert.assertEquals((Collection)((Collection)store.getChildren("/non-existing-key/child").join()), Collections.emptyList());
            try {
                store.delete("/non-existing-key", Optional.empty()).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.NotFoundException.class);
            }
            try {
                store.delete("/non-existing-key", Optional.of(1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                Assert.assertTrue((MetadataStoreException.NotFoundException.class.isInstance(e.getCause()) || MetadataStoreException.BadVersionException.class.isInstance(e.getCause()) ? 1 : 0) != 0);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void concurrentPutTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            String data = "data";
            String path = "/non-existing-key";
            int concurrent = 50;
            ArrayList<CompletionStage> futureList = new ArrayList<CompletionStage>();
            for (int i = 0; i < concurrent; ++i) {
                futureList.add(store.put(path, data.getBytes(), Optional.empty()).exceptionally(ex -> {
                    Assert.fail((String)"fail to execute concurrent put", (Throwable)ex);
                    return null;
                }));
            }
            FutureUtil.waitForAll(futureList).join();
            Assert.assertEquals((byte[])((GetResult)((Optional)store.get(path).join()).get()).getValue(), (byte[])data.getBytes());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void insertionTestWithExpectedVersion(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            String key1 = this.newKey();
            try {
                store.put(key1, "value-1".getBytes(), Optional.of(0L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            try {
                store.put(key1, "value-1".getBytes(), Optional.of(1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            Stat putRes = (Stat)store.put(key1, "value-1".getBytes(), Optional.of(-1L)).join();
            long putVersion = putRes.getVersion();
            Assert.assertTrue((putVersion >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)putRes.isFirstVersion());
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            Optional optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-1".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)putVersion);
            try {
                store.put(key1, "value-2".getBytes(), Optional.of(-1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            try {
                store.put(key1, "value-2".getBytes(), Optional.of(putVersion + 1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-1".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)putVersion);
            putRes = (Stat)store.put(key1, "value-2".getBytes(), Optional.of(putVersion)).join();
            Assert.assertTrue((putRes.getVersion() > putVersion ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-2".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)putRes.getVersion());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void getChildrenTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            int i;
            String key = this.newKey();
            int n = 10;
            ArrayList<CallSite> expectedChildren = new ArrayList<CallSite>();
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), Collections.emptyList());
            for (i = 0; i < n; ++i) {
                store.put(key + "/c-" + i, new byte[0], Optional.empty()).join();
                expectedChildren.add((CallSite)((Object)("c-" + i)));
            }
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), expectedChildren);
            for (i = 0; i < n; ++i) {
                store.put(key + "/c-0/cc-" + i, new byte[0], Optional.empty()).join();
            }
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), expectedChildren);
            for (i = 0; i < n; ++i) {
                store.deleteRecursive(key + "/c-" + i).join();
            }
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), Collections.emptyList());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void navigateChildrenTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String key = this.newKey();
            store.put(key + "/c-0/cc-1", new byte[0], Optional.empty()).join();
            store.put(key + "/c-0/cc-2/ccc-1", new byte[0], Optional.empty()).join();
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), Collections.singletonList("c-0"));
            Assert.assertEquals((Collection)((Collection)store.getChildren(key + "/c-0").join()), (Collection)Lists.newArrayList((Object[])new String[]{"cc-1", "cc-2"}));
            Assert.assertEquals((Collection)((Collection)store.getChildren(key + "/c-0/cc-2").join()), (Collection)Lists.newArrayList((Object[])new String[]{"ccc-1"}));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void deletionTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            String key = this.newKey();
            int n = 10;
            ArrayList<CallSite> expectedChildren = new ArrayList<CallSite>();
            for (int i = 0; i < n; ++i) {
                store.put(key + "/c-" + i, new byte[0], Optional.empty()).join();
                expectedChildren.add((CallSite)((Object)("c-" + i)));
            }
            try {
                store.delete(key, Optional.empty()).join();
                Assert.fail((String)"The key has children");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            for (int i = 0; i < n; ++i) {
                try {
                    store.delete(key + "/c-" + i, Optional.of(1L)).join();
                    Assert.fail((String)"The key has children");
                }
                catch (CompletionException e) {
                    MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
                }
                store.delete(key + "/c-" + i, Optional.empty()).join();
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void emptyKeyTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            try {
                store.delete("", Optional.empty()).join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.getChildren("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.get("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.exists("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.put("", new byte[0], Optional.empty()).join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void notificationListeners(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            LinkedBlockingDeque notifications = new LinkedBlockingDeque();
            store.registerListener(n -> notifications.add(n));
            String key1 = this.newKey();
            Assert.assertFalse((boolean)((Optional)store.get(key1).join()).isPresent());
            Stat stat = (Stat)store.put(key1, "value-1".getBytes(), Optional.empty()).join();
            Assert.assertTrue((boolean)((Optional)store.get(key1).join()).isPresent());
            Assert.assertEquals((Collection)((Collection)store.getChildren(key1).join()), Collections.emptyList());
            Assert.assertTrue((stat.getVersion() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)stat.isFirstVersion());
            Notification n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Created);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            long firstVersion = stat.getVersion();
            stat = (Stat)store.put(key1, "value-2".getBytes(), Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Modified);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            Assert.assertTrue((stat.getVersion() > firstVersion ? 1 : 0) != 0);
            String key1Child = key1 + "/xx";
            Assert.assertFalse((boolean)((Optional)store.get(key1Child).join()).isPresent());
            store.put(key1Child, "value-2".getBytes(), Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Created);
            Assert.assertEquals((String)n2.getPath(), (String)key1Child);
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.ChildrenChanged);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            Assert.assertTrue((boolean)((Boolean)store.exists(key1Child).join()));
            Assert.assertEquals((Collection)((Collection)store.getChildren(key1).join()), Collections.singletonList("xx"));
            store.delete(key1Child, Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Deleted);
            Assert.assertEquals((String)n2.getPath(), (String)key1Child);
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.ChildrenChanged);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testDeleteRecursive(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            String prefix = this.newKey();
            String key1 = this.newKey();
            store.put(prefix + key1, "value-1".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c1", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c2", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c1/x1", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c1/x2", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c2/y2", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c3", "value".getBytes(), Optional.of(-1L)).join();
            String key2 = this.newKey();
            store.put(prefix + key2, "value-2".getBytes(), Optional.of(-1L)).join();
            store.deleteRecursive(prefix + key1).join();
            Assert.assertEquals((Collection)((Collection)store.getChildren(prefix).join()), Collections.singletonList(key2.substring(1)));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testDeleteUnusedDirectories(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            String prefix = this.newKey();
            store.put(prefix + "/a1/b1/c1", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + "/a1/b1/c2", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + "/a1/b2/c1", "value".getBytes(), Optional.of(-1L)).join();
            store.delete(prefix + "/a1/b1/c1", Optional.empty()).join();
            store.delete(prefix + "/a1/b1/c2", Optional.empty()).join();
            this.zks.checkContainers();
            Assert.assertFalse((boolean)((Boolean)store.exists(prefix + "/a1/b1").join()));
            store.delete(prefix + "/a1/b2/c1", Optional.empty()).join();
            this.zks.checkContainers();
            Assert.assertFalse((boolean)((Boolean)store.exists(prefix + "/a1/b2").join()));
            this.zks.checkContainers();
            Assert.assertFalse((boolean)((Boolean)store.exists(prefix + "/a1").join()));
            this.zks.checkContainers();
            Assert.assertFalse((boolean)((Boolean)store.exists(prefix).join()));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    @DataProvider(name="conditionOfSwitchThread")
    public Object[][] conditionOfSwitchThread() {
        return new Object[][]{{false, false}, {false, true}, {true, false}, {true, true}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="conditionOfSwitchThread")
    public void testThreadSwitchOfZkMetadataStore(boolean hasSynchronizer, boolean enabledBatch) throws Exception {
        String prefix = this.newKey();
        String metadataStoreName = UUID.randomUUID().toString().replaceAll("-", "");
        MetadataStoreConfig.MetadataStoreConfigBuilder builder = MetadataStoreConfig.builder().metadataStoreName(metadataStoreName);
        builder.fsyncEnable(false);
        builder.batchingEnabled(enabledBatch);
        if (!hasSynchronizer) {
            builder.synchronizer(null);
        }
        MetadataStoreConfig config = builder.build();
        ZKMetadataStore store = (ZKMetadataStore)MetadataStoreFactory.create((String)this.zks.getConnectionString(), (MetadataStoreConfig)config);
        try {
            Runnable verify = () -> {
                String currentThreadName = Thread.currentThread().getName();
                String errorMessage = String.format("Expect to switch to thread %s, but currently it is thread %s", metadataStoreName, currentThreadName);
                Assert.assertTrue((boolean)Thread.currentThread().getName().startsWith(metadataStoreName), (String)errorMessage);
            };
            ((CompletableFuture)store.put(prefix + "/a1/b1/c1", "value".getBytes(), Optional.of(-1L)).thenApply(ignore -> {
                verify.run();
                return null;
            })).join();
            ((CompletableFuture)store.put(prefix + "/b1", "value".getBytes(), Optional.of(-1L)).thenApply(ignore -> {
                verify.run();
                return null;
            })).join();
            ((CompletableFuture)store.get(prefix + "/b1").thenApply(ignore -> {
                verify.run();
                return null;
            })).join();
            ((CompletableFuture)store.get(prefix + "/non").thenApply(ignore -> {
                verify.run();
                return null;
            })).join();
            ((CompletableFuture)store.delete(prefix + "/b1", Optional.empty()).thenApply(ignore -> {
                verify.run();
                return null;
            })).join();
            ((CompletableFuture)((CompletableFuture)store.delete(prefix + "/non", Optional.empty()).thenApply(ignore -> {
                verify.run();
                return null;
            })).exceptionally(ex -> {
                verify.run();
                return null;
            })).join();
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    @Test(dataProvider="impl")
    public void testPersistent(String provider, Supplier<String> urlSupplier) throws Exception {
        String metadataUrl = urlSupplier.get();
        MetadataStore store = MetadataStoreFactory.create((String)metadataUrl, (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        byte[] data = "testPersistent".getBytes(StandardCharsets.UTF_8);
        String key = this.newKey() + "/a/b/c";
        store.put(key, data, Optional.of(-1L)).join();
        store.close();
        store = MetadataStoreFactory.create((String)metadataUrl, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        Optional result = (Optional)store.get(key).get();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((byte[])((GetResult)result.get()).getValue(), (byte[])data);
        store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testConcurrentPutGetOneKey(String provider, Supplier<String> urlSupplier) throws Exception {
        final MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            byte[] data = new byte[]{0};
            final String path = this.newKey();
            final int maxValue = 100;
            store.put(path, data, Optional.of(-1L)).join();
            final AtomicInteger successWrites = new AtomicInteger(0);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    GetResult readResult;
                    byte value;
                    while ((value = (byte)((readResult = (GetResult)((Optional)store.get(path).get()).get()).getValue()[0] + 1)) <= maxValue) {
                        CompletionStage putResult = store.put(path, new byte[]{value}, Optional.of(readResult.getStat().getVersion())).thenRun(successWrites::incrementAndGet);
                        try {
                            ((CompletableFuture)putResult).get();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        log.info("Put value {} success:{}. ", (Object)value, (Object)(!((CompletableFuture)putResult).isCompletedExceptionally() ? 1 : 0));
                    }
                }
            };
            CompletionStage t1 = CompletableFuture.completedFuture(null).thenRunAsync(task);
            CompletionStage t2 = CompletableFuture.completedFuture(null).thenRunAsync(task);
            task.run();
            ((CompletableFuture)t1).join();
            ((CompletableFuture)t2).join();
            Assert.assertFalse((boolean)((CompletableFuture)t1).isCompletedExceptionally());
            Assert.assertFalse((boolean)((CompletableFuture)t2).isCompletedExceptionally());
            Assert.assertEquals((int)successWrites.get(), (int)maxValue);
            Assert.assertEquals((int)((GetResult)((Optional)store.get(path).get()).get()).getValue()[0], (int)maxValue);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testConcurrentPut(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            String k = this.newKey();
            CompletableFuture<Void> f1 = CompletableFuture.runAsync(() -> store.put(k, new byte[0], Optional.of(-1L)).join());
            CompletableFuture<Void> f2 = CompletableFuture.runAsync(() -> store.put(k, new byte[0], Optional.of(-1L)).join());
            Awaitility.await().until(() -> f1.isDone() && f2.isDone());
            Assert.assertTrue((f1.isCompletedExceptionally() && !f2.isCompletedExceptionally() || !f1.isCompletedExceptionally() && f2.isCompletedExceptionally() ? 1 : 0) != 0);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testConcurrentDelete(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            String k = this.newKey();
            store.put(k, new byte[0], Optional.of(-1L)).join();
            CompletableFuture<Void> f1 = CompletableFuture.runAsync(() -> store.delete(k, Optional.empty()).join());
            CompletableFuture<Void> f2 = CompletableFuture.runAsync(() -> store.delete(k, Optional.empty()).join());
            Awaitility.await().until(() -> f1.isDone() && f2.isDone());
            Assert.assertTrue((f1.isCompletedExceptionally() && !f2.isCompletedExceptionally() || !f1.isCompletedExceptionally() && f2.isCompletedExceptionally() ? 1 : 0) != 0);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testGetChildren(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            store.put("/a/a-1", "value1".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
            store.put("/a/a-2", "value1".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
            store.put("/b/c/b/1", "value1".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
            List subPaths = (List)store.getChildren("/").get();
            Set<String> expectedSet = "ZooKeeper".equals(provider) ? Set.of("a", "b", "zookeeper") : Set.of("a", "b");
            for (String subPath : subPaths) {
                Assert.assertTrue((boolean)expectedSet.contains(subPath));
            }
            List subPaths2 = (List)store.getChildren("/a").get();
            Set<String> expectedSet2 = Set.of("a-1", "a-2");
            for (String subPath : subPaths2) {
                Assert.assertTrue((boolean)expectedSet2.contains(subPath));
            }
            List subPaths3 = (List)store.getChildren("/b").get();
            Set<String> expectedSet3 = Set.of("c");
            for (String subPath : subPaths3) {
                Assert.assertTrue((boolean)expectedSet3.contains(subPath));
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testClosedMetadataStore(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            store.close();
            try {
                store.get("/a").get();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof MetadataStoreException.AlreadyClosedException));
            }
            try {
                store.put("/a", new byte[0], Optional.empty()).get();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof MetadataStoreException.AlreadyClosedException));
            }
            try {
                store.delete("/a", Optional.empty()).get();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof MetadataStoreException.AlreadyClosedException));
            }
            try {
                store.deleteRecursive("/a").get();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof MetadataStoreException.AlreadyClosedException));
            }
            try {
                store.getChildren("/a").get();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof MetadataStoreException.AlreadyClosedException));
            }
            try {
                store.exists("/a").get();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof MetadataStoreException.AlreadyClosedException));
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="distributedImpl")
    public void testGetChildrenDistributed(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store1 = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            MetadataStore store2 = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
            try {
                String parent = this.newKey();
                byte[] value = "value1".getBytes(StandardCharsets.UTF_8);
                store1.put(parent, value, Optional.empty()).get();
                store1.put(parent + "/a", value, Optional.empty()).get();
                Assert.assertEquals((Collection)((Collection)store1.getChildren(parent).get()), List.of("a"));
                store1.delete(parent + "/a", Optional.empty()).get();
                Assert.assertEquals((Collection)((Collection)store1.getChildren(parent).get()), Collections.emptyList());
                store1.delete(parent, Optional.empty()).get();
                Assert.assertEquals((Collection)((Collection)store1.getChildren(parent).get()), Collections.emptyList());
                store2.put(parent + "/b", value, Optional.empty()).get();
                Awaitility.await().atMost(3L, TimeUnit.SECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assert.assertEquals((Collection)((Collection)store1.getChildren(parent).get()), List.of("b")));
                store2.put(parent + "/c", value, Optional.empty()).get();
                Awaitility.await().atMost(3L, TimeUnit.SECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assert.assertEquals((Collection)((Collection)store1.getChildren(parent).get()), List.of("b", "c")));
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="distributedImpl")
    public void testExistsDistributed(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store1 = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
        try {
            MetadataStore store2 = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().fsyncEnable(false).build());
            try {
                String parent = this.newKey();
                byte[] value = "value1".getBytes(StandardCharsets.UTF_8);
                Assert.assertFalse((boolean)((Boolean)store1.exists(parent).get()));
                store1.put(parent, value, Optional.empty()).get();
                Assert.assertTrue((boolean)((Boolean)store1.exists(parent).get()));
                Assert.assertFalse((boolean)((Boolean)store1.exists(parent + "/a").get()));
                store2.put(parent + "/a", value, Optional.empty()).get();
                Assert.assertTrue((boolean)((Boolean)store1.exists(parent + "/a").get()));
                Awaitility.await().atMost(3L, TimeUnit.SECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assert.assertFalse((boolean)((Boolean)store1.exists(parent + "/b").get())));
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }
}

