/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.embedded.ExitHandler;
import org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import org.assertj.core.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class TestZKServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TestZKServer.class);
    public static final int TICK_TIME = 1000;
    private final File zkDataDir = Files.newTemporaryFolder();
    private int zkPort;
    private ZooKeeperServerEmbedded zooKeeperServerEmbedded;

    public TestZKServer() throws Exception {
        this.zkDataDir.deleteOnExit();
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        System.setProperty("zookeeper.admin.enableServer", "false");
        this.start();
    }

    public void start() throws Exception {
        Properties configZookeeper = new Properties();
        configZookeeper.put("clientPort", "" + this.zkPort);
        configZookeeper.put("host", "127.0.0.1");
        configZookeeper.put("ticktime", "1000");
        this.zooKeeperServerEmbedded = ZooKeeperServerEmbedded.builder().baseDir(this.zkDataDir.toPath()).configuration(configZookeeper).exitHandler(ExitHandler.LOG_ONLY).build();
        this.zooKeeperServerEmbedded.start(60000L);
        log.info("Started test ZK server on at {}", (Object)this.zooKeeperServerEmbedded.getConnectionString());
        ZooKeeperServerMain zooKeeperServerMain = TestZKServer.getZooKeeperServerMain(this.zooKeeperServerEmbedded);
        ServerCnxnFactory serverCnxnFactory = TestZKServer.getServerCnxnFactory(zooKeeperServerMain);
        this.zkPort = serverCnxnFactory.getLocalPort();
        boolean zkServerReady = TestZKServer.waitForServerUp(this.getConnectionString(), 30000L);
        Assert.assertTrue((boolean)zkServerReady);
    }

    private static ZooKeeperServerMain getZooKeeperServerMain(ZooKeeperServerEmbedded zooKeeperServerEmbedded) {
        ZooKeeperServerMain zooKeeperServerMain = (ZooKeeperServerMain)TestZKServer.readField(zooKeeperServerEmbedded.getClass(), "mainsingle", zooKeeperServerEmbedded);
        return zooKeeperServerMain;
    }

    private static ContainerManager getContainerManager(ZooKeeperServerMain zooKeeperServerMain) {
        ContainerManager containerManager = (ContainerManager)TestZKServer.readField(ZooKeeperServerMain.class, "containerManager", zooKeeperServerMain);
        return containerManager;
    }

    private static ZooKeeperServer getZooKeeperServer(ZooKeeperServerMain zooKeeperServerMain) {
        ServerCnxnFactory serverCnxnFactory = TestZKServer.getServerCnxnFactory(zooKeeperServerMain);
        ZooKeeperServer zkServer = (ZooKeeperServer)TestZKServer.readField(ServerCnxnFactory.class, "zkServer", serverCnxnFactory);
        return zkServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readField(Class clazz, String field, Object object) {
        Field declaredField = clazz.getDeclaredField(field);
        boolean accessible = declaredField.isAccessible();
        if (!accessible) {
            declaredField.setAccessible(true);
        }
        try {
            Object object2 = declaredField.get(object);
            return (T)object2;
        }
        finally {
            declaredField.setAccessible(accessible);
        }
    }

    private static ServerCnxnFactory getServerCnxnFactory(ZooKeeperServerMain zooKeeperServerMain) throws Exception {
        ServerCnxnFactory serverCnxnFactory = (ServerCnxnFactory)TestZKServer.readField(ZooKeeperServerMain.class, "cnxnFactory", zooKeeperServerMain);
        return serverCnxnFactory;
    }

    public void checkContainers() throws Exception {
        Thread.sleep(1000L);
        ContainerManager containerManager = TestZKServer.getContainerManager(TestZKServer.getZooKeeperServerMain(this.zooKeeperServerEmbedded));
        containerManager.checkContainers();
    }

    public void stop() throws Exception {
        if (this.zooKeeperServerEmbedded != null) {
            this.zooKeeperServerEmbedded.close();
            this.zooKeeperServerEmbedded = null;
        }
        log.info("Stopped test ZK server");
    }

    public void expireSession(long sessionId) {
        TestZKServer.getZooKeeperServer(TestZKServer.getZooKeeperServerMain(this.zooKeeperServerEmbedded)).expire(sessionId);
    }

    @Override
    public void close() throws Exception {
        this.stop();
        FileUtils.deleteDirectory((File)this.zkDataDir);
    }

    public String getConnectionString() {
        return this.zooKeeperServerEmbedded.getConnectionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        String[] split = hp.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try {
                Socket sock = new Socket(host, port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        log.info("ZK Server UP");
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                log.info("ZK server {} not up: {}", (Object)hp, (Object)e.getMessage());
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

