/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.bookkeeper.BKCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EndToEndTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(EndToEndTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testBasic(String provider, Supplier<String> urlSupplier) throws Exception {
        BKCluster bktc = BKCluster.builder().metadataServiceUri(urlSupplier.get()).build();
        try {
            BookKeeper bkc = bktc.newClient();
            try {
                long ledgerId;
                WriteHandle wh = (WriteHandle)bkc.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute().join();
                try {
                    for (int i = 0; i < 10; ++i) {
                        wh.append(("entry-" + i).getBytes(StandardCharsets.UTF_8));
                        log.info("Written entry {}", (Object)i);
                    }
                    ledgerId = wh.getId();
                }
                finally {
                    if (Collections.singletonList(wh).get(0) != null) {
                        wh.close();
                    }
                }
                ReadHandle rh = (ReadHandle)bkc.newOpenLedgerOp().withLedgerId(ledgerId).withPassword(new byte[0]).execute().join();
                try {
                    LedgerEntries les = rh.read(0L, 9L);
                    try {
                        int i = 0;
                        for (LedgerEntry le : les) {
                            Assert.assertEquals((String)new String(le.getEntryBytes()), (String)("entry-" + i++));
                        }
                    }
                    finally {
                        if (Collections.singletonList(les).get(0) != null) {
                            les.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(rh).get(0) != null) {
                        rh.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(bkc).get(0) != null) {
                    bkc.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bktc).get(0) != null) {
                bktc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testWithLedgerRecovery(String provider, Supplier<String> urlSupplier) throws Exception {
        BKCluster bktc = BKCluster.builder().metadataServiceUri(urlSupplier.get()).numBookies(3).build();
        try {
            BookKeeper bkc = bktc.newClient();
            try {
                WriteHandle wh = (WriteHandle)bkc.newCreateLedgerOp().withEnsembleSize(3).withWriteQuorumSize(2).withAckQuorumSize(2).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute().join();
                try {
                    for (int i = 0; i < 10; ++i) {
                        wh.append(("entry-" + i).getBytes(StandardCharsets.UTF_8));
                    }
                    long ledgerId = wh.getId();
                    ReadHandle rh = (ReadHandle)bkc.newOpenLedgerOp().withLedgerId(ledgerId).withPassword(new byte[0]).withRecovery(true).execute().join();
                    try {
                        Assert.assertEquals((long)rh.getLastAddConfirmed(), (long)9L);
                        LedgerEntries les = rh.read(0L, 9L);
                        try {
                            int i = 0;
                            for (LedgerEntry le : les) {
                                Assert.assertEquals((String)new String(le.getEntryBytes()), (String)("entry-" + i++));
                            }
                            try {
                                wh.append("test".getBytes(StandardCharsets.UTF_8));
                                Assert.fail((String)"should have failed since the ledger is fenced");
                            }
                            catch (BKException.BKLedgerFencedException bKLedgerFencedException) {
                                // empty catch block
                            }
                        }
                        finally {
                            if (Collections.singletonList(les).get(0) != null) {
                                les.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(rh).get(0) != null) {
                            rh.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(wh).get(0) != null) {
                        wh.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(bkc).get(0) != null) {
                    bkc.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bktc).get(0) != null) {
                bktc.close();
            }
        }
    }
}

