/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarLayoutManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class PulsarLayoutManagerTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(PulsarLayoutManagerTest.class);
    private static final int managerVersion = 43981;
    private MetadataStoreExtended store;
    private LayoutManager layoutManager;
    private String ledgersRootPath;

    private void methodSetup(Supplier<String> urlSupplier) throws Exception {
        this.ledgersRootPath = "/ledgers-" + UUID.randomUUID();
        this.store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        this.layoutManager = new PulsarLayoutManager(this.store, this.ledgersRootPath);
    }

    @AfterMethod(alwaysRun=true)
    public final void methodCleanup() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Test(dataProvider="impl")
    public void testReadCreateDeleteLayout(String provider, Supplier<String> urlSupplier) throws Exception {
        this.methodSetup(urlSupplier);
        try {
            this.layoutManager.readLedgerLayout();
            Assert.fail((String)"should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LedgerLayout layout = new LedgerLayout(PulsarLedgerManagerFactory.class.getName(), 43981);
        this.layoutManager.storeLedgerLayout(layout);
        LedgerLayout readLayout = this.layoutManager.readLedgerLayout();
        Assert.assertEquals((Object)readLayout, (Object)layout);
        LedgerLayout newLayout = new LedgerLayout("new layout", 43982);
        try {
            this.layoutManager.storeLedgerLayout(newLayout);
            Assert.fail((String)"Should fail storeLedgerLayout if layout already exists");
        }
        catch (LayoutManager.LedgerLayoutExistsException ledgerLayoutExistsException) {
            // empty catch block
        }
        readLayout = this.layoutManager.readLedgerLayout();
        Assert.assertEquals((Object)layout, (Object)readLayout);
        this.layoutManager.deleteLedgerLayout();
        try {
            this.layoutManager.readLedgerLayout();
            Assert.fail((String)"should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.layoutManager.deleteLedgerLayout();
            Assert.fail((String)"Should fail deleteLedgerLayout is layout not found");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().contains("NotFoundException"));
        }
    }
}

