/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.net.URI;
import org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PulsarMetadataDriverBaseStaticTest {
    @Test
    public void testGetZKServersFromServiceUri() {
        String uriStr = "zk://server1;server2;server3/ledgers";
        URI uri = URI.create(uriStr);
        String zkServers = ZKMetadataDriverBase.getZKServersFromServiceUri((URI)uri);
        Assert.assertEquals((String)zkServers, (String)"server1,server2,server3");
        uriStr = "zk://server1,server2,server3/ledgers";
        uri = URI.create(uriStr);
        zkServers = ZKMetadataDriverBase.getZKServersFromServiceUri((URI)uri);
        Assert.assertEquals((String)zkServers, (String)"server1,server2,server3");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testResolveLedgerManagerFactoryNullUri() {
        ZKMetadataDriverBase.resolveLedgerManagerFactory(null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testResolveLedgerManagerFactoryNullScheme() {
        ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("//127.0.0.1/ledgers"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testResolveLedgerManagerFactoryUnknownScheme() {
        ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("unknown://127.0.0.1/ledgers"));
    }

    @Test
    public void testResolveLedgerManagerFactoryUnspecifiedLayout() {
        Assert.assertEquals((Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk://127.0.0.1/ledgers")), null);
    }

    @Test
    public void testResolveLedgerManagerFactoryNullLayout() {
        Assert.assertEquals((Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+null://127.0.0.1/ledgers")), null);
    }

    @Test
    public void testResolveLedgerManagerFactoryFlat() {
        Assert.assertEquals((Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+flat://127.0.0.1/ledgers")), FlatLedgerManagerFactory.class);
    }

    @Test
    public void testResolveLedgerManagerFactoryMs() {
        Assert.assertEquals((Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+ms://127.0.0.1/ledgers")), MSLedgerManagerFactory.class);
    }

    @Test
    public void testResolveLedgerManagerFactoryHierarchical() {
        Assert.assertEquals((Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+hierarchical://127.0.0.1/ledgers")), HierarchicalLedgerManagerFactory.class);
    }

    @Test
    public void testResolveLedgerManagerFactoryLongHierarchical() {
        Assert.assertEquals((Object)ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+longhierarchical://127.0.0.1/ledgers")), LongHierarchicalLedgerManagerFactory.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testResolveLedgerManagerFactoryUnknownLedgerManagerFactory() {
        ZKMetadataDriverBase.resolveLedgerManagerFactory((URI)URI.create("zk+unknown://127.0.0.1/ledgers"));
    }
}

