/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.coordination.impl;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.coordination.impl.CoordinationServiceImpl;
import org.apache.pulsar.metadata.coordination.impl.LeaderElectionImpl;
import org.testng.annotations.Test;

public class LeaderElectionImplTest
extends BaseMetadataStoreTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl", timeOut=20000L)
    public void validateDeadLock(String provider, Supplier<String> urlSupplier) throws Exception {
        if (provider.equals("Memory") || provider.equals("RocksDB")) {
            return;
        }
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String path = this.newKey();
            CoordinationServiceImpl cs = new CoordinationServiceImpl(store);
            try {
                LeaderElectionImpl le = (LeaderElectionImpl)cs.getLeaderElection(String.class, path, __ -> {});
                try {
                    CompletableFuture blockFuture = new CompletableFuture();
                    le.getSchedulerExecutor().execute(() -> {
                        try {
                            le.elect((Object)"test-2").join();
                            blockFuture.complete(null);
                        }
                        catch (Throwable ex) {
                            blockFuture.completeExceptionally(ex);
                        }
                    });
                    blockFuture.join();
                }
                finally {
                    if (Collections.singletonList(le).get(0) != null) {
                        le.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(cs).get(0) != null) {
                    cs.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }
}

