/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.io.Resources;
import io.etcd.jetcd.launcher.EtcdCluster;
import io.etcd.jetcd.test.EtcdClusterExtension;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.impl.EtcdConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EtcdMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(EtcdMetadataStoreTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCluster() throws Exception {
        EtcdCluster etcdCluster = EtcdClusterExtension.builder().withClusterName("test-cluster").withNodes(3).withSsl(false).build().cluster();
        try {
            etcdCluster.start();
            EtcdConfig etcdConfig = EtcdConfig.builder().useTls(false).tlsProvider(null).authority("etcd0").build();
            Path etcdConfigPath = Files.createTempFile("etcd_config_cluster", ".yml", new FileAttribute[0]);
            new ObjectMapper((JsonFactory)new YAMLFactory()).writeValue(etcdConfigPath.toFile(), (Object)etcdConfig);
            String metadataURL = "etcd:" + etcdCluster.clientEndpoints().stream().map(URI::toString).collect(Collectors.joining(","));
            MetadataStore store = MetadataStoreFactory.create((String)metadataURL, (MetadataStoreConfig)MetadataStoreConfig.builder().configFilePath(etcdConfigPath.toString()).build());
            try {
                store.put("/test", "value".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
                Assert.assertTrue((boolean)((Boolean)store.exists("/test").join()));
            }
            finally {
                if (Collections.singletonList(store).get(0) != null) {
                    store.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(etcdCluster).get(0) != null) {
                etcdCluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithTls() throws Exception {
        EtcdCluster etcdCluster = EtcdClusterExtension.builder().withClusterName("test-cluster").withNodes(3).withSsl(true).build().cluster();
        try {
            etcdCluster.start();
            EtcdConfig etcdConfig = EtcdConfig.builder().useTls(true).tlsProvider(null).authority("etcd0").tlsTrustCertsFilePath(Resources.getResource((String)"ssl/cert/ca.pem").getPath()).tlsKeyFilePath(Resources.getResource((String)"ssl/cert/client-key-pk8.pem").getPath()).tlsCertificateFilePath(Resources.getResource((String)"ssl/cert/client.pem").getPath()).build();
            Path etcdConfigPath = Files.createTempFile("etcd_config_cluster_ssl", ".yml", new FileAttribute[0]);
            new ObjectMapper((JsonFactory)new YAMLFactory()).writeValue(etcdConfigPath.toFile(), (Object)etcdConfig);
            String metadataURL = "etcd:" + etcdCluster.clientEndpoints().stream().map(URI::toString).collect(Collectors.joining(","));
            MetadataStore store = MetadataStoreFactory.create((String)metadataURL, (MetadataStoreConfig)MetadataStoreConfig.builder().configFilePath(etcdConfigPath.toString()).build());
            try {
                store.put("/test", "value".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
                Assert.assertTrue((boolean)((Boolean)store.exists("/test").join()));
            }
            finally {
                if (Collections.singletonList(store).get(0) != null) {
                    store.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(etcdCluster).get(0) != null) {
                etcdCluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTlsInstance() throws Exception {
        EtcdCluster etcdCluster = EtcdClusterExtension.builder().withClusterName("test-tls").withNodes(1).withSsl(true).build().cluster();
        try {
            etcdCluster.start();
            EtcdConfig etcdConfig = EtcdConfig.builder().useTls(true).tlsProvider(null).authority("etcd0").tlsTrustCertsFilePath(Resources.getResource((String)"ssl/cert/ca.pem").getPath()).tlsKeyFilePath(Resources.getResource((String)"ssl/cert/client-key-pk8.pem").getPath()).tlsCertificateFilePath(Resources.getResource((String)"ssl/cert/client.pem").getPath()).build();
            Path etcdConfigPath = Files.createTempFile("etcd_config", ".yml", new FileAttribute[0]);
            new ObjectMapper((JsonFactory)new YAMLFactory()).writeValue(etcdConfigPath.toFile(), (Object)etcdConfig);
            String metadataURL = "etcd:" + etcdCluster.clientEndpoints().stream().map(URI::toString).collect(Collectors.joining(","));
            MetadataStore store = MetadataStoreFactory.create((String)metadataURL, (MetadataStoreConfig)MetadataStoreConfig.builder().configFilePath(etcdConfigPath.toString()).build());
            try {
                store.put("/test", "value".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
                Assert.assertTrue((boolean)((Boolean)store.exists("/test").join()));
            }
            finally {
                if (Collections.singletonList(store).get(0) != null) {
                    store.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(etcdCluster).get(0) != null) {
                etcdCluster.close();
            }
        }
    }
}

