/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataEvent;
import org.apache.pulsar.metadata.api.MetadataEventSynchronizer;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LocalMemoryMetadataStoreTest {
    HashSet<CreateOption> EMPTY_SET = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotifyEvent() throws Exception {
        TestMetadataEventSynchronizer sync = new TestMetadataEventSynchronizer();
        MetadataStore store1 = MetadataStoreFactory.create((String)"memory:local", (MetadataStoreConfig)MetadataStoreConfig.builder().synchronizer((MetadataEventSynchronizer)sync).build());
        try {
            MetadataEvent event2;
            long exptectedVersion;
            String path = "/test";
            byte[] value = "value".getBytes(StandardCharsets.UTF_8);
            store1.put(path, value, Optional.empty()).join();
            Assert.assertTrue((boolean)((Boolean)store1.exists(path).join()));
            MetadataEvent event = sync.notifiedEvents.get(path);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> event != null);
            Assert.assertNotNull((Object)event);
            Assert.assertEquals((String)event.getPath(), (String)path);
            Assert.assertEquals((byte[])event.getValue(), (byte[])value);
            Assert.assertEquals((Set)event.getOptions(), this.EMPTY_SET);
            Assert.assertEquals((Object)event.getType(), (Object)NotificationType.Modified);
            Assert.assertEquals((String)event.getSourceCluster(), (String)sync.clusterName);
            Assert.assertNull((Object)event.getExpectedVersion());
            for (exptectedVersion = 0L; exptectedVersion < 4L; ++exptectedVersion) {
                sync.notifiedEvents.remove(path);
                store1.put(path, value, Optional.of(exptectedVersion)).join();
                event2 = sync.notifiedEvents.get(path);
                Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> event2 != null);
                Assert.assertNotNull((Object)event2);
                Assert.assertEquals((String)event2.getPath(), (String)path);
                Assert.assertEquals((long)event2.getExpectedVersion(), (long)exptectedVersion);
                Assert.assertEquals((Object)event2.getType(), (Object)NotificationType.Modified);
            }
            sync.notifiedEvents.remove(path);
            store1.delete(path, Optional.of(exptectedVersion)).join();
            event2 = sync.notifiedEvents.get(path);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> event2 != null);
            Assert.assertNotNull((Object)event2);
            Assert.assertEquals((String)event2.getPath(), (String)path);
            Assert.assertEquals((long)event2.getExpectedVersion(), (long)exptectedVersion);
            Assert.assertEquals((Object)event2.getType(), (Object)NotificationType.Deleted);
            Assert.assertEquals((String)event2.getSourceCluster(), (String)sync.clusterName);
            Assert.assertEquals((Set)event2.getOptions(), this.EMPTY_SET);
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsIgnoreEvent() throws Exception {
        TestMetadataEventSynchronizer sync = new TestMetadataEventSynchronizer();
        AbstractMetadataStore store1 = (AbstractMetadataStore)MetadataStoreFactory.create((String)"memory:local", (MetadataStoreConfig)MetadataStoreConfig.builder().synchronizer((MetadataEventSynchronizer)sync).build());
        try {
            String path = "/test";
            byte[] value1 = "value1".getBytes(StandardCharsets.UTF_8);
            byte[] value2 = "value2".getBytes(StandardCharsets.UTF_8);
            store1.put(path, value1, Optional.empty()).join();
            long time1 = Instant.now().toEpochMilli();
            long time2 = time1 - 5L;
            Stat stats = new Stat(path, 0L, time2, time2, false, false);
            GetResult eixistingData = new GetResult(value1, stats);
            MetadataEvent event = new MetadataEvent(path, value1, Sets.newHashSet((Object[])new CreateOption[]{CreateOption.Ephemeral}), Long.valueOf(0L), time1, sync.getClusterName(), NotificationType.Modified);
            Assert.assertTrue((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(10L), time1, sync.getClusterName(), NotificationType.Modified);
            Assert.assertTrue((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(0L), time1, sync.getClusterName(), NotificationType.Modified);
            Assert.assertFalse((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(0L), time1, null, NotificationType.Modified);
            Assert.assertTrue((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(0L), time2, sync.getClusterName(), NotificationType.Modified);
            Assert.assertFalse((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(10L), time2, sync.getClusterName(), NotificationType.Modified);
            Assert.assertTrue((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, null, time2, sync.getClusterName(), NotificationType.Modified);
            Assert.assertFalse((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(0L), time2 - 5L, sync.getClusterName(), NotificationType.Modified);
            Assert.assertTrue((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(0L), time2, "uest", NotificationType.Modified);
            Assert.assertFalse((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(0L), time2 - 5L, "uest", NotificationType.Modified);
            Assert.assertTrue((boolean)store1.shouldIgnoreEvent(event, eixistingData));
            event = new MetadataEvent(path, value1, this.EMPTY_SET, Long.valueOf(0L), time2, "rest", NotificationType.Modified);
            Assert.assertTrue((boolean)store1.shouldIgnoreEvent(event, eixistingData));
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncListener() throws Exception {
        TestMetadataEventSynchronizer sync = new TestMetadataEventSynchronizer();
        MetadataStore store1 = MetadataStoreFactory.create((String)"memory:local", (MetadataStoreConfig)MetadataStoreConfig.builder().synchronizer((MetadataEventSynchronizer)sync).build());
        try {
            String path = "/test";
            byte[] value1 = "value1".getBytes(StandardCharsets.UTF_8);
            byte[] value2 = "value2".getBytes(StandardCharsets.UTF_8);
            store1.put(path, value1, Optional.empty()).join();
            Assert.assertTrue((boolean)((Boolean)store1.exists(path).join()));
            Stat stats = ((GetResult)((Optional)store1.get(path).get()).get()).getStat();
            MetadataEvent event = new MetadataEvent(path, value2, this.EMPTY_SET, Long.valueOf(stats.getVersion()), stats.getModificationTimestamp() + 1L, sync.clusterName, NotificationType.Modified);
            sync.listener.apply(event).get();
            Assert.assertEquals((byte[])((GetResult)((Optional)store1.get(path).get()).get()).getValue(), (byte[])value2);
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }

    static class TestMetadataEventSynchronizer
    implements MetadataEventSynchronizer {
        public Map<String, MetadataEvent> notifiedEvents = new ConcurrentHashMap<String, MetadataEvent>();
        public String clusterName = "test";
        public volatile Function<MetadataEvent, CompletableFuture<Void>> listener;

        TestMetadataEventSynchronizer() {
        }

        public CompletableFuture<Void> notify(MetadataEvent event) {
            this.notifiedEvents.put(event.getPath(), event);
            return CompletableFuture.completedFuture(null);
        }

        public void registerSyncListener(Function<MetadataEvent, CompletableFuture<Void>> fun) {
            this.listener = fun;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public void close() {
        }
    }
}

