/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataEventSynchronizerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrivateInstance() throws Exception {
        MetadataStore store1 = MetadataStoreFactory.create((String)"memory:local", (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataStore store2 = MetadataStoreFactory.create((String)"memory:local", (MetadataStoreConfig)MetadataStoreConfig.builder().build());
            try {
                store1.put("/test", "value".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
                Assert.assertTrue((boolean)((Boolean)store1.exists("/test").join()));
                Assert.assertFalse((boolean)((Boolean)store2.exists("/test").join()));
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedInstance() throws Exception {
        String url = "memory:" + UUID.randomUUID();
        MetadataStore store1 = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            MetadataStore store2 = MetadataStoreFactory.create((String)url, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
            try {
                store1.put("/test", "value".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
                Assert.assertTrue((boolean)((Boolean)store1.exists("/test").join()));
                Assert.assertTrue((boolean)((Boolean)store2.exists("/test").join()));
                store2.delete("/test", Optional.empty()).join();
                Assert.assertFalse((boolean)((Boolean)store2.exists("/test").join()));
                Awaitility.await().untilAsserted(() -> Assert.assertFalse((boolean)((Boolean)store1.exists("/test").join())));
            }
            finally {
                if (Collections.singletonList(store2).get(0) != null) {
                    store2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store1).get(0) != null) {
                store1.close();
            }
        }
    }

    @Test
    public void testPathValid() {
        Assert.assertFalse((boolean)AbstractMetadataStore.isValidPath(null));
        Assert.assertFalse((boolean)AbstractMetadataStore.isValidPath((String)""));
        Assert.assertFalse((boolean)AbstractMetadataStore.isValidPath((String)" "));
        Assert.assertTrue((boolean)AbstractMetadataStore.isValidPath((String)"/"));
        Assert.assertTrue((boolean)AbstractMetadataStore.isValidPath((String)"/test"));
        Assert.assertFalse((boolean)AbstractMetadataStore.isValidPath((String)"/test/"));
        Assert.assertTrue((boolean)AbstractMetadataStore.isValidPath((String)"/test/ABC"));
    }
}

