/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreProvider;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.apache.pulsar.metadata.impl.MetadataStoreFactoryImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MetadataStoreFactoryImplTest {
    private static Object originalProperty;

    @BeforeClass
    public void setMetadataStoreProperty() {
        originalProperty = System.getProperties().get("pulsar.metadatastore.providers");
        System.setProperty("pulsar.metadatastore.providers", MyMetadataStoreProvider.class.getName());
    }

    @AfterClass
    public void resetMetadataStoreProperty() {
        if (originalProperty != null) {
            System.getProperties().put("pulsar.metadatastore.providers", originalProperty);
        }
    }

    @Test
    public void testCreate() throws Exception {
        MetadataStore instance = MetadataStoreFactoryImpl.create((String)"custom://localhost", (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            Assert.assertTrue((boolean)(instance instanceof MyMetadataStore));
        }
        finally {
            if (Collections.singletonList(instance).get(0) != null) {
                instance.close();
            }
        }
    }

    @Test
    public void testRemoveIdentifierFromMetadataURL() {
        Assert.assertEquals((String)MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)"zk:host:port"), (String)"host:port");
        Assert.assertEquals((String)MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)"rocksdb:/data/dir"), (String)"/data/dir");
        Assert.assertEquals((String)MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)"etcd:host:port"), (String)"host:port");
        Assert.assertEquals((String)MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)"memory:name"), (String)"name");
        Assert.assertEquals((String)MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)"http://unknown/url/scheme"), (String)"http://unknown/url/scheme");
        Assert.assertEquals((String)MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)"custom:suffix"), (String)"suffix");
    }

    public static class MyMetadataStoreProvider
    implements MetadataStoreProvider {
        public String urlScheme() {
            return "custom";
        }

        public MetadataStore create(String metadataURL, MetadataStoreConfig metadataStoreConfig, boolean enableSessionWatcher) throws MetadataStoreException {
            return new MyMetadataStore();
        }
    }

    public static class MyMetadataStore
    extends AbstractMetadataStore {
        protected MyMetadataStore() {
            super("custom");
        }

        protected CompletableFuture<List<String>> getChildrenFromStore(String path) {
            return null;
        }

        protected CompletableFuture<Boolean> existsFromStore(String path) {
            return null;
        }

        protected CompletableFuture<Optional<GetResult>> storeGet(String path) {
            return null;
        }

        protected CompletableFuture<Void> storeDelete(String path, Optional<Long> expectedVersion) {
            return null;
        }

        protected CompletableFuture<Stat> storePut(String path, byte[] data, Optional<Long> optExpectedVersion, EnumSet<CreateOption> options) {
            return null;
        }
    }
}

