/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.impl.RocksdbMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RocksdbMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(RocksdbMetadataStoreTest.class);

    @Test
    public void testConvert() {
        String s = "testConvert";
        Assert.assertEquals((String)s, (String)RocksdbMetadataStore.toString((byte[])RocksdbMetadataStore.toBytes((String)s)));
        long l = 12345L;
        Assert.assertEquals((long)l, (long)RocksdbMetadataStore.toLong((byte[])RocksdbMetadataStore.toBytes((long)l)));
    }

    @Test
    public void testMetaValue() throws Exception {
        RocksdbMetadataStore.MetaValue metaValue = new RocksdbMetadataStore.MetaValue();
        metaValue.setVersion(RandomUtils.nextLong());
        metaValue.setOwner(RandomUtils.nextLong());
        metaValue.setCreatedTimestamp(RandomUtils.nextLong());
        metaValue.setModifiedTimestamp(RandomUtils.nextLong());
        metaValue.setEphemeral(RandomUtils.nextBoolean());
        metaValue.setData(String.valueOf(RandomUtils.nextDouble()).getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)RocksdbMetadataStore.MetaValue.parse((byte[])metaValue.serialize()), (Object)metaValue);
    }

    @Test
    public void testOpenDbWithConfigFile() throws Exception {
        Path tempDir = Files.createTempDirectory("RocksdbMetadataStoreTest", new FileAttribute[0]);
        log.info("Temp dir:{}", (Object)tempDir.toAbsolutePath());
        String optionFilePath = this.getClass().getClassLoader().getResource("rocksdb_option_file_example.ini").getPath();
        log.info("optionFilePath={}", (Object)optionFilePath);
        MetadataStore store = MetadataStoreFactory.create((String)("rocksdb:" + tempDir.toAbsolutePath()), (MetadataStoreConfig)MetadataStoreConfig.builder().configFilePath(optionFilePath).build());
        Assert.assertTrue((boolean)(store instanceof RocksdbMetadataStore));
        String path = "/test";
        byte[] data = "data".getBytes();
        CompletableFuture f = store.put(path, data, Optional.of(-1L));
        CompletableFuture failedPut = store.put(path, data, Optional.of(100L));
        Assert.expectThrows(MetadataStoreException.BadVersionException.class, () -> {
            try {
                failedPut.get();
            }
            catch (ExecutionException t) {
                throw t.getCause();
            }
        });
        Assert.assertNotNull(f.get());
        log.info("put result:{}", f.get());
        Assert.assertNotNull((Object)store.put(path + "/a", data, Optional.of(-1L)));
        Assert.assertNotNull((Object)store.put(path + "/b", data, Optional.of(-1L)));
        Assert.assertNotNull((Object)store.put(path + "/c", data, Optional.of(-1L)));
        store.close();
        store = MetadataStoreFactory.create((String)("rocksdb:" + tempDir.toAbsolutePath()), (MetadataStoreConfig)MetadataStoreConfig.builder().configFilePath(optionFilePath).build());
        CompletableFuture readResult = store.get(path);
        Assert.assertNotNull(readResult.get());
        Assert.assertTrue((boolean)((Optional)readResult.get()).isPresent());
        GetResult r = (GetResult)((Optional)readResult.get()).get();
        Assert.assertEquals((String)path, (String)r.getStat().getPath());
        Assert.assertEquals((long)0L, (long)r.getStat().getVersion());
        Assert.assertEquals((byte[])data, (byte[])r.getValue());
        store.close();
        FileUtils.deleteQuietly((File)tempDir.toFile());
    }

    @Test
    public void testMultipleInstances() throws Exception {
        Path tempDir = Files.createTempDirectory("RocksdbMetadataStoreTest", new FileAttribute[0]);
        log.info("Temp dir:{}", (Object)tempDir.toAbsolutePath());
        MetadataStore store1 = MetadataStoreFactory.create((String)("rocksdb:" + tempDir.toAbsolutePath()), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        MetadataStore store2 = MetadataStoreFactory.create((String)("rocksdb:" + tempDir.toAbsolutePath()), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        Assert.assertTrue((store1 == store2 ? 1 : 0) != 0);
        store1.put("/test", new byte[0], Optional.empty()).join();
        Assert.assertTrue((boolean)((Boolean)store2.exists("/test").join()));
        store1.close();
        store2.put("/test-2", new byte[0], Optional.empty()).join();
        Assert.assertTrue((boolean)((Boolean)store2.exists("/test-2").join()));
        store2.close();
        FileUtils.deleteQuietly((File)tempDir.toFile());
    }
}

