/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.packages.management.core.PackagesManagement;
import org.apache.pulsar.packages.management.core.PackagesStorage;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import org.apache.pulsar.packages.management.core.common.PackageMetadataUtil;
import org.apache.pulsar.packages.management.core.common.PackageName;
import org.apache.pulsar.packages.management.core.common.PackageType;
import org.apache.pulsar.packages.management.core.exceptions.PackagesManagementException;

public class PackagesManagementImpl
implements PackagesManagement {
    private PackagesStorage storage;

    @Override
    public void initialize(PackagesStorage storage) {
        this.storage = storage;
    }

    @Override
    public CompletableFuture<PackageMetadata> getMeta(PackageName packageName) {
        CompletableFuture<PackageMetadata> future = new CompletableFuture<PackageMetadata>();
        String metadataPath = this.metadataPath(packageName);
        this.checkMetadataNotExistsAndThrowException(packageName).whenComplete((ignore, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                ((CompletableFuture)this.storage.readAsync(metadataPath, outputStream).thenCompose(aVoid -> this.metadataReadFromStream(outputStream))).whenComplete((metadata, t) -> {
                    if (t != null) {
                        future.completeExceptionally((Throwable)t);
                    } else {
                        future.complete((PackageMetadata)metadata);
                    }
                });
            }
            catch (IOException e) {
                future.completeExceptionally((Throwable)new PackagesManagementException(String.format("Read package '%s' metadata failed", packageName.toString()), (Throwable)e));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> updateMeta(PackageName packageName, PackageMetadata metadata) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        String metadataPath = this.metadataPath(packageName);
        this.checkMetadataNotExistsAndThrowException(packageName).whenComplete((ignore, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(PackageMetadataUtil.toBytes(metadata));){
                ((CompletableFuture)this.storage.deleteAsync(metadataPath).thenCompose(aVoid -> this.storage.writeAsync(metadataPath, inputStream))).whenComplete((aVoid, t) -> {
                    if (t != null) {
                        future.completeExceptionally((Throwable)new PackagesManagementException(String.format("Update package '%s' metadata failed", packageName.toString()), t));
                    } else {
                        future.complete(null);
                    }
                });
            }
            catch (IOException e) {
                future.completeExceptionally((Throwable)new PackagesManagementException(String.format("Read package '%s' metadata failed", packageName.toString()), (Throwable)e));
            }
        });
        return future;
    }

    private CompletableFuture<Void> writeMeta(PackageName packageName, PackageMetadata metadata) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        String metadataPath = this.metadataPath(packageName);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(PackageMetadataUtil.toBytes(metadata));){
            this.storage.writeAsync(metadataPath, inputStream).whenComplete((aVoid, t) -> {
                if (t != null) {
                    future.completeExceptionally((Throwable)new PackagesManagementException(String.format("Update package '%s' metadata failed", packageName.toString()), t));
                } else {
                    future.complete(null);
                }
            });
        }
        catch (IOException e) {
            future.completeExceptionally((Throwable)new PackagesManagementException(String.format("Read package '%s' metadata failed", packageName.toString()), (Throwable)e));
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> download(PackageName packageName, OutputStream outputStream) {
        String packagePath = this.packagePath(packageName);
        return this.checkPackageNotExistsAndThrowException(packageName).thenCompose(ignore -> this.storage.readAsync(packagePath, outputStream));
    }

    @Override
    public CompletableFuture<Void> upload(PackageName packageName, PackageMetadata metadata, InputStream inputStream) {
        return ((CompletableFuture)CompletableFuture.allOf(this.checkMetadataExistsAndThrowException(packageName), this.checkPackageExistsAndThrowException(packageName)).thenCompose(ignore -> this.writeMeta(packageName, metadata))).thenCompose(ignore -> this.storage.writeAsync(this.packagePath(packageName), inputStream));
    }

    @Override
    public CompletableFuture<Void> delete(PackageName packageName) {
        return CompletableFuture.allOf(this.storage.deleteAsync(this.metadataPath(packageName)), this.storage.deleteAsync(this.packagePath(packageName)));
    }

    @Override
    public CompletableFuture<List<String>> list(PackageName packageName) {
        return this.storage.listAsync(this.packageWithoutVersionPath(packageName));
    }

    @Override
    public CompletableFuture<List<String>> list(PackageType type, String tenant, String namespace) {
        return this.storage.listAsync(String.format("%s/%s/%s", type, tenant, namespace));
    }

    private CompletableFuture<Void> checkMetadataNotExistsAndThrowException(PackageName packageName) {
        String path = this.metadataPath(packageName);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.storage.existAsync(path).whenComplete((exist, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            if (exist.booleanValue()) {
                future.complete(null);
            } else {
                future.completeExceptionally((Throwable)new PackagesManagementException.NotFoundException(String.format("Package '%s' metadata does not exist", packageName)));
            }
        });
        return future;
    }

    private CompletableFuture<Void> checkMetadataExistsAndThrowException(PackageName packageName) {
        String path = this.metadataPath(packageName);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.storage.existAsync(path).whenComplete((exist, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            if (!exist.booleanValue()) {
                future.complete(null);
            } else {
                future.completeExceptionally((Throwable)new PackagesManagementException.NotFoundException(String.format("Package '%s' metadata already exists", packageName)));
            }
        });
        return future;
    }

    private CompletableFuture<Void> checkPackageNotExistsAndThrowException(PackageName packageName) {
        String path = this.packagePath(packageName);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.storage.existAsync(path).whenComplete((exist, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            if (exist.booleanValue()) {
                future.complete(null);
            } else {
                future.completeExceptionally((Throwable)new PackagesManagementException.NotFoundException(String.format("Package '%s' does not exist", packageName.toString())));
            }
        });
        return future;
    }

    private CompletableFuture<Void> checkPackageExistsAndThrowException(PackageName packageName) {
        String path = this.packagePath(packageName);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.storage.existAsync(path).whenComplete((exist, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            if (!exist.booleanValue()) {
                future.complete(null);
            } else {
                future.completeExceptionally((Throwable)new PackagesManagementException.NotFoundException(String.format("Package '%s' already exists", packageName.toString())));
            }
        });
        return future;
    }

    private CompletableFuture<PackageMetadata> metadataReadFromStream(ByteArrayOutputStream outputStream) {
        CompletableFuture<PackageMetadata> future = new CompletableFuture<PackageMetadata>();
        try {
            PackageMetadata metadata = PackageMetadataUtil.fromBytes(outputStream.toByteArray());
            future.complete(metadata);
        }
        catch (PackagesManagementException.MetadataFormatException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    protected String metadataPath(PackageName packageName) {
        return packageName.toRestPath() + "/meta";
    }

    protected String packagePath(PackageName packageName) {
        return packageName.toRestPath() + this.storage.dataPath();
    }

    private String packageWithoutVersionPath(PackageName packageName) {
        return String.format("%s/%s/%s/%s", packageName.getPkgType().toString(), packageName.getTenant(), packageName.getNamespace(), packageName.getName());
    }
}

