/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.informationschema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public enum InformationSchemaTable {
    COLUMNS(InformationSchemaTable.table("columns").column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_name", (Type)VarcharType.createUnboundedVarcharType()).column("ordinal_position", (Type)BigintType.BIGINT).column("column_default", (Type)VarcharType.createUnboundedVarcharType()).column("is_nullable", (Type)VarcharType.createUnboundedVarcharType()).column("data_type", (Type)VarcharType.createUnboundedVarcharType()).hiddenColumn("comment", (Type)VarcharType.createUnboundedVarcharType()).hiddenColumn("extra_info", (Type)VarcharType.createUnboundedVarcharType()).hiddenColumn("column_comment", (Type)VarcharType.createUnboundedVarcharType()).build()),
    TABLES(InformationSchemaTable.table("tables").column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_type", (Type)VarcharType.createUnboundedVarcharType()).hiddenColumn("table_comment", (Type)VarcharType.createUnboundedVarcharType()).build()),
    VIEWS(InformationSchemaTable.table("views").column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("view_definition", (Type)VarcharType.createUnboundedVarcharType()).build()),
    SCHEMATA(InformationSchemaTable.table("schemata").column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).build()),
    TABLE_PRIVILEGES(InformationSchemaTable.table("table_privileges").column("grantor", (Type)VarcharType.createUnboundedVarcharType()).column("grantor_type", (Type)VarcharType.createUnboundedVarcharType()).column("grantee", (Type)VarcharType.createUnboundedVarcharType()).column("grantee_type", (Type)VarcharType.createUnboundedVarcharType()).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("privilege_type", (Type)VarcharType.createUnboundedVarcharType()).column("is_grantable", (Type)VarcharType.createUnboundedVarcharType()).column("with_hierarchy", (Type)VarcharType.createUnboundedVarcharType()).build()),
    ROLES(InformationSchemaTable.table("roles").column("role_name", (Type)VarcharType.createUnboundedVarcharType()).build()),
    APPLICABLE_ROLES(InformationSchemaTable.table("applicable_roles").column("grantee", (Type)VarcharType.createUnboundedVarcharType()).column("grantee_type", (Type)VarcharType.createUnboundedVarcharType()).column("role_name", (Type)VarcharType.createUnboundedVarcharType()).column("is_grantable", (Type)VarcharType.createUnboundedVarcharType()).build()),
    ENABLED_ROLES(InformationSchemaTable.table("enabled_roles").column("role_name", (Type)VarcharType.createUnboundedVarcharType()).build());

    public static final String INFORMATION_SCHEMA = "information_schema";
    private final ConnectorTableMetadata tableMetadata;

    private InformationSchemaTable(ConnectorTableMetadata tableMetadata) {
        this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
    }

    private static MetadataUtil.TableMetadataBuilder table(String tableName) {
        return MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(new SchemaTableName(INFORMATION_SCHEMA, tableName));
    }

    public static Optional<InformationSchemaTable> of(SchemaTableName schemaTableName) {
        if (!schemaTableName.getSchemaName().equals(INFORMATION_SCHEMA)) {
            return Optional.empty();
        }
        try {
            return Optional.of(InformationSchemaTable.valueOf(schemaTableName.getTableName().toUpperCase(Locale.ENGLISH)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public SchemaTableName getSchemaTableName() {
        return this.tableMetadata.getTable();
    }

    @JsonCreator
    public InformationSchemaTable fromStringValue(String value) {
        return InformationSchemaTable.valueOf(value);
    }

    @JsonValue
    public String toStringValue() {
        return this.name();
    }
}

