/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import io.prestosql.FullConnectorSession;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataListing;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class CatalogSystemTable
implements SystemTable {
    public static final SchemaTableName CATALOG_TABLE_NAME = new SchemaTableName("metadata", "catalogs");
    public static final ConnectorTableMetadata CATALOG_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(CATALOG_TABLE_NAME).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("connector_id", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public CatalogSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return CATALOG_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)CATALOG_TABLE);
        for (Map.Entry<String, CatalogName> entry : MetadataListing.listCatalogs(session, this.metadata, this.accessControl).entrySet()) {
            table.addRow(new Object[]{entry.getKey(), entry.getValue().toString()});
        }
        return table.build().cursor();
    }
}

