/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.cost.LocalCostEstimate;
import java.util.Objects;

public final class PlanCostEstimate {
    private static final PlanCostEstimate INFINITE = new PlanCostEstimate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final PlanCostEstimate UNKNOWN = new PlanCostEstimate(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    private static final PlanCostEstimate ZERO = new PlanCostEstimate(0.0, 0.0, 0.0, 0.0);
    private final double cpuCost;
    private final double maxMemory;
    private final double maxMemoryWhenOutputting;
    private final double networkCost;
    private final LocalCostEstimate rootNodeLocalCostEstimate;

    public static PlanCostEstimate infinite() {
        return INFINITE;
    }

    public static PlanCostEstimate unknown() {
        return UNKNOWN;
    }

    public static PlanCostEstimate zero() {
        return ZERO;
    }

    public PlanCostEstimate(double cpuCost, double maxMemory, double maxMemoryWhenOutputting, double networkCost) {
        this(cpuCost, maxMemory, maxMemoryWhenOutputting, networkCost, LocalCostEstimate.unknown());
    }

    @JsonCreator
    public PlanCostEstimate(@JsonProperty(value="cpuCost") double cpuCost, @JsonProperty(value="maxMemory") double maxMemory, @JsonProperty(value="maxMemoryWhenOutputting") double maxMemoryWhenOutputting, @JsonProperty(value="networkCost") double networkCost, @JsonProperty(value="rootNodeLocalCostEstimate") LocalCostEstimate rootNodeLocalCostEstimate) {
        Preconditions.checkArgument((!(cpuCost < 0.0) ? 1 : 0) != 0, (String)"cpuCost cannot be negative: %s", (Object)cpuCost);
        Preconditions.checkArgument((!(maxMemory < 0.0) ? 1 : 0) != 0, (String)"maxMemory cannot be negative: %s", (Object)maxMemory);
        Preconditions.checkArgument((!(maxMemoryWhenOutputting < 0.0) ? 1 : 0) != 0, (String)"maxMemoryWhenOutputting cannot be negative: %s", (Object)maxMemoryWhenOutputting);
        Preconditions.checkArgument((!(maxMemoryWhenOutputting > maxMemory) ? 1 : 0) != 0, (String)"maxMemoryWhenOutputting cannot be greater than maxMemory: %s > %s", (Object)maxMemoryWhenOutputting, (Object)maxMemory);
        Preconditions.checkArgument((!(networkCost < 0.0) ? 1 : 0) != 0, (String)"networkCost cannot be negative: %s", (Object)networkCost);
        this.cpuCost = cpuCost;
        this.maxMemory = maxMemory;
        this.maxMemoryWhenOutputting = maxMemoryWhenOutputting;
        this.networkCost = networkCost;
        this.rootNodeLocalCostEstimate = Objects.requireNonNull(rootNodeLocalCostEstimate, "rootNodeLocalCostEstimate is null");
    }

    @JsonProperty
    public double getCpuCost() {
        return this.cpuCost;
    }

    @JsonProperty
    public double getMaxMemory() {
        return this.maxMemory;
    }

    @JsonProperty
    public double getMaxMemoryWhenOutputting() {
        return this.maxMemoryWhenOutputting;
    }

    @JsonProperty
    public double getNetworkCost() {
        return this.networkCost;
    }

    @JsonProperty
    public LocalCostEstimate getRootNodeLocalCostEstimate() {
        return this.rootNodeLocalCostEstimate;
    }

    public boolean hasUnknownComponents() {
        return Double.isNaN(this.cpuCost) || Double.isNaN(this.maxMemory) || Double.isNaN(this.maxMemoryWhenOutputting) || Double.isNaN(this.networkCost);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpu", this.cpuCost).add("memory", this.maxMemory).add("network", this.networkCost).add("rootNodeLocalCostEstimate", (Object)this.rootNodeLocalCostEstimate).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanCostEstimate that = (PlanCostEstimate)o;
        return Double.compare(that.cpuCost, this.cpuCost) == 0 && Double.compare(that.maxMemory, this.maxMemory) == 0 && Double.compare(that.maxMemoryWhenOutputting, this.maxMemoryWhenOutputting) == 0 && Double.compare(that.networkCost, this.networkCost) == 0 && Objects.equals(this.rootNodeLocalCostEstimate, that.rootNodeLocalCostEstimate);
    }

    public int hashCode() {
        return Objects.hash(this.cpuCost, this.maxMemory, this.maxMemoryWhenOutputting, this.networkCost, this.rootNodeLocalCostEstimate);
    }
}

