/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.LowMemoryKiller;
import io.prestosql.memory.MemoryInfo;
import io.prestosql.spi.QueryId;
import java.util.List;
import java.util.Optional;

public class TotalReservationLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<QueryId> chooseQueryToKill(List<LowMemoryKiller.QueryMemoryInfo> runningQueries, List<MemoryInfo> nodes) {
        QueryId biggestQuery = null;
        long maxMemory = 0L;
        for (LowMemoryKiller.QueryMemoryInfo query : runningQueries) {
            long bytesUsed = query.getMemoryReservation();
            if (bytesUsed <= maxMemory || !LocalMemoryManager.GENERAL_POOL.equals((Object)query.getMemoryPoolId())) continue;
            biggestQuery = query.getQueryId();
            maxMemory = bytesUsed;
        }
        return Optional.ofNullable(biggestQuery);
    }
}

