/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.TypeSignatureParser;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.tree.QualifiedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ResolvedFunction {
    private static final String PREFIX = "@";
    private final Signature signature;
    private final FunctionId functionId;

    @JsonCreator
    public ResolvedFunction(@JsonProperty(value="signature") Signature signature, @JsonProperty(value="id") FunctionId functionId) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        Preconditions.checkArgument((signature.getTypeVariableConstraints().isEmpty() && signature.getLongVariableConstraints().isEmpty() ? 1 : 0) != 0, (String)"%s has unbound type parameters", (Object)signature);
        Preconditions.checkArgument((!signature.isVariableArity() ? 1 : 0) != 0, (String)"%s has variable arity", (Object)signature);
    }

    @JsonProperty
    public Signature getSignature() {
        return this.signature;
    }

    @JsonProperty(value="id")
    public FunctionId getFunctionId() {
        return this.functionId;
    }

    public QualifiedName toQualifiedName() {
        return QualifiedName.of((String)(PREFIX + ResolvedFunction.encodeSimpleSignature(this.signature) + PREFIX + this.functionId));
    }

    public static Optional<ResolvedFunction> fromQualifiedName(QualifiedName name) {
        String data = name.getSuffix();
        if (!data.startsWith(PREFIX)) {
            return Optional.empty();
        }
        List parts = Splitter.on((String)PREFIX).splitToList(data.subSequence(1, data.length()));
        Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"Expected encoded resolved function to contain two parts: %s", (Object)name);
        Signature signature = ResolvedFunction.decodeSimpleSignature((String)parts.get(0));
        FunctionId functionId = new FunctionId((String)parts.get(1));
        return Optional.of(new ResolvedFunction(signature, functionId));
    }

    private static String encodeSimpleSignature(Signature signature) {
        ArrayList<String> parts = new ArrayList<String>(2 + signature.getArgumentTypes().size());
        parts.add(signature.getName());
        parts.add((String)signature.getReturnType());
        parts.addAll(signature.getArgumentTypes());
        return Joiner.on((char)'|').join(parts).toLowerCase(Locale.US);
    }

    private static Signature decodeSimpleSignature(String encodedSignature) {
        List parts = Splitter.on((char)'|').splitToList((CharSequence)encodedSignature);
        Preconditions.checkArgument((parts.size() >= 2 ? 1 : 0) != 0, (String)"Expected encoded signature to contain at least 2 parts: %s", (Object)encodedSignature);
        String name = (String)parts.get(0);
        TypeSignature returnType = TypeSignatureParser.parseTypeSignature((String)parts.get(1), (Set<String>)ImmutableSet.of());
        List argumentTypes = (List)parts.subList(2, parts.size()).stream().map(part -> TypeSignatureParser.parseTypeSignature(part, (Set<String>)ImmutableSet.of())).collect(ImmutableList.toImmutableList());
        return new Signature(name, returnType, argumentTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedFunction that = (ResolvedFunction)o;
        return Objects.equals(this.signature, that.signature) && Objects.equals(this.functionId, that.functionId);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.functionId);
    }

    public String toString() {
        return this.signature.toString();
    }
}

