/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.JsonNode;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.operator.OperatorInfo;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import java.util.Objects;
import java.util.Optional;

public class TableFinishInfo
implements OperatorInfo {
    private static final int JSON_LENGTH_LIMIT = Math.toIntExact(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
    private static final JsonCodec<Object> INFO_CODEC = JsonCodec.jsonCodec(Object.class);
    private static final JsonCodec<JsonNode> JSON_NODE_CODEC = JsonCodec.jsonCodec(JsonNode.class);
    private final String connectorOutputMetadata;
    private final boolean jsonLengthLimitExceeded;
    private final Duration statisticsWallTime;
    private final Duration statisticsCpuTime;

    public TableFinishInfo(Optional<ConnectorOutputMetadata> metadata, Duration statisticsWallTime, Duration statisticsCpuTime) {
        String connectorOutputMetadata = null;
        boolean jsonLengthLimitExceeded = false;
        if (metadata.isPresent()) {
            Optional serializedMetadata = INFO_CODEC.toJsonWithLengthLimit(metadata.get().getInfo(), JSON_LENGTH_LIMIT);
            if (!serializedMetadata.isPresent()) {
                connectorOutputMetadata = null;
                jsonLengthLimitExceeded = true;
            } else {
                connectorOutputMetadata = (String)serializedMetadata.get();
                jsonLengthLimitExceeded = false;
            }
        }
        this.connectorOutputMetadata = connectorOutputMetadata;
        this.jsonLengthLimitExceeded = jsonLengthLimitExceeded;
        this.statisticsWallTime = Objects.requireNonNull(statisticsWallTime, "statisticsWallTime is null");
        this.statisticsCpuTime = Objects.requireNonNull(statisticsCpuTime, "statisticsCpuTime is null");
    }

    @JsonCreator
    public TableFinishInfo(@JsonProperty(value="connectorOutputMetadata") JsonNode connectorOutputMetadata, @JsonProperty(value="jsonLengthLimitExceeded") boolean jsonLengthLimitExceeded, @JsonProperty(value="statisticsWallTime") Duration statisticsWallTime, @JsonProperty(value="statisticsCpuTime") Duration statisticsCpuTime) {
        this.connectorOutputMetadata = JSON_NODE_CODEC.toJson((Object)connectorOutputMetadata);
        this.jsonLengthLimitExceeded = jsonLengthLimitExceeded;
        this.statisticsWallTime = Objects.requireNonNull(statisticsWallTime, "statisticsWallTime is null");
        this.statisticsCpuTime = Objects.requireNonNull(statisticsCpuTime, "statisticsCpuTime is null");
    }

    @JsonProperty
    @JsonRawValue
    public String getConnectorOutputMetadata() {
        return this.connectorOutputMetadata;
    }

    @JsonProperty
    public boolean isJsonLengthLimitExceeded() {
        return this.jsonLengthLimitExceeded;
    }

    @JsonProperty
    public Duration getStatisticsWallTime() {
        return this.statisticsWallTime;
    }

    @JsonProperty
    public Duration getStatisticsCpuTime() {
        return this.statisticsCpuTime;
    }

    @Override
    public boolean isFinal() {
        return true;
    }
}

