/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;
import io.prestosql.operator.aggregation.state.HyperLogLogState;
import io.prestosql.operator.aggregation.state.StateCompiler;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;

@AggregationFunction(value="merge")
public final class MergeHyperLogLogAggregation {
    private static final AccumulatorStateSerializer<HyperLogLogState> serializer = StateCompiler.generateStateSerializer(HyperLogLogState.class);

    private MergeHyperLogLogAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @SqlType(value="HyperLogLog") Slice value) {
        HyperLogLog input = HyperLogLog.newInstance((Slice)value);
        MergeHyperLogLogAggregation.merge(state, input);
    }

    @CombineFunction
    public static void combine(@AggregationState HyperLogLogState state, @AggregationState HyperLogLogState otherState) {
        MergeHyperLogLogAggregation.merge(state, otherState.getHyperLogLog());
    }

    private static void merge(@AggregationState HyperLogLogState state, HyperLogLog input) {
        HyperLogLog previous = state.getHyperLogLog();
        if (previous == null) {
            state.setHyperLogLog(input);
            state.addMemoryUsage(input.estimatedInMemorySize());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySize());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySize());
        }
    }

    @OutputFunction(value="HyperLogLog")
    public static void output(@AggregationState HyperLogLogState state, BlockBuilder out) {
        serializer.serialize((Object)state, out);
    }
}

