/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.state.NullableDoubleState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.RealType;

@AggregationFunction(value="sum")
public final class RealSumAggregation {
    private RealSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState NullableDoubleState state, @SqlType(value="real") long value) {
        state.setNull(false);
        state.setDouble(state.getDouble() + (double)Float.intBitsToFloat((int)value));
    }

    @CombineFunction
    public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        if (state.isNull()) {
            if (otherState.isNull()) {
                return;
            }
            state.setNull(false);
            state.setDouble(otherState.getDouble());
            return;
        }
        if (!otherState.isNull()) {
            state.setDouble(state.getDouble() + otherState.getDouble());
        }
    }

    @OutputFunction(value="real")
    public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)state.getDouble()));
        }
    }
}

