/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.spi.function.InvocationConvention;
import java.lang.invoke.MethodHandle;
import java.util.Optional;

public abstract class ScalarImplementationDependency
implements ImplementationDependency {
    private final Optional<InvocationConvention> invocationConvention;

    protected ScalarImplementationDependency(Optional<InvocationConvention> invocationConvention) {
        this.invocationConvention = invocationConvention;
    }

    protected abstract ResolvedFunction getResolvedFunction(BoundVariables var1, Metadata var2);

    @Override
    public MethodHandle resolve(BoundVariables boundVariables, Metadata metadata) {
        ResolvedFunction resolvedFunction = this.getResolvedFunction(boundVariables, metadata);
        if (this.invocationConvention.isPresent()) {
            return metadata.getFunctionInvokerProvider().createFunctionInvoker(resolvedFunction, this.invocationConvention).methodHandle();
        }
        return metadata.getScalarFunctionImplementation(resolvedFunction).getMethodHandle();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

