/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.TypeSignatureParser;
import io.prestosql.operator.window.ReflectionWindowFunctionSupplier;
import io.prestosql.operator.window.SqlWindowFunction;
import io.prestosql.spi.function.WindowFunction;
import io.prestosql.spi.function.WindowFunctionSignature;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public final class WindowAnnotationsParser {
    private WindowAnnotationsParser() {
    }

    public static List<SqlWindowFunction> parseFunctionDefinition(Class<? extends WindowFunction> clazz) {
        WindowFunctionSignature[] signatures = (WindowFunctionSignature[])clazz.getAnnotationsByType(WindowFunctionSignature.class);
        Preconditions.checkArgument((signatures.length > 0 ? 1 : 0) != 0, (String)"Class is not annotated with @WindowFunctionSignature: %s", (Object)clazz.getName());
        return (List)Stream.of(signatures).map(signature -> WindowAnnotationsParser.parse(clazz, signature)).collect(ImmutableList.toImmutableList());
    }

    private static SqlWindowFunction parse(Class<? extends WindowFunction> clazz, WindowFunctionSignature window) {
        ImmutableList typeVariables = ImmutableList.of();
        if (!window.typeVariable().isEmpty()) {
            typeVariables = ImmutableList.of((Object)Signature.typeVariable(window.typeVariable()));
        }
        List argumentTypes = (List)Stream.of(window.argumentTypes()).map(type -> TypeSignatureParser.parseTypeSignature(type, (Set<String>)ImmutableSet.of())).collect(ImmutableList.toImmutableList());
        Signature signature = new Signature(window.name(), (List<TypeVariableConstraint>)typeVariables, (List<LongVariableConstraint>)ImmutableList.of(), TypeSignatureParser.parseTypeSignature(window.returnType(), (Set<String>)ImmutableSet.of()), argumentTypes, false);
        boolean deprecated = ((Deprecated[])clazz.getAnnotationsByType(Deprecated.class)).length > 0;
        return new SqlWindowFunction(new ReflectionWindowFunctionSupplier<WindowFunction>(signature, clazz), deprecated);
    }
}

