/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import com.google.common.io.ByteStreams;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.TaskId;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.NodeState;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlUtil;
import io.prestosql.server.ForWorkerInfo;
import io.prestosql.server.HttpRequestSessionContext;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.GroupProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/ui/api/worker")
public class WorkerResource {
    private final DispatchManager dispatchManager;
    private final InternalNodeManager nodeManager;
    private final AccessControl accessControl;
    private final HttpClient httpClient;
    private final GroupProvider groupProvider;

    @Inject
    public WorkerResource(DispatchManager dispatchManager, InternalNodeManager nodeManager, AccessControl accessControl, @ForWorkerInfo HttpClient httpClient, GroupProvider groupProvider) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
    }

    @GET
    @Path(value="{nodeId}/status")
    public Response getStatus(@PathParam(value="nodeId") String nodeId) {
        return this.proxyJsonResponse(nodeId, "v1/status");
    }

    @GET
    @Path(value="{nodeId}/thread")
    public Response getThreads(@PathParam(value="nodeId") String nodeId) {
        return this.proxyJsonResponse(nodeId, "v1/thread");
    }

    @GET
    @Path(value="{nodeId}/task/{taskId}")
    public Response getThreads(@PathParam(value="taskId") TaskId task, @PathParam(value="nodeId") String nodeId, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        QueryId queryId = task.getQueryId();
        Optional<QueryInfo> queryInfo = this.dispatchManager.getFullQueryInfo(queryId);
        if (queryInfo.isPresent()) {
            try {
                AccessControlUtil.checkCanViewQueryOwnedBy(HttpRequestSessionContext.extractAuthorizedIdentity(servletRequest, httpHeaders, this.accessControl, this.groupProvider), queryInfo.get().getSession().getUser(), this.accessControl);
                return this.proxyJsonResponse(nodeId, "v1/task/" + task);
            }
            catch (AccessDeniedException e) {
                throw new ForbiddenException();
            }
        }
        return Response.status((Response.Status)Response.Status.GONE).build();
    }

    private Response proxyJsonResponse(String nodeId, String workerPath) {
        Set<InternalNode> nodes = this.nodeManager.getNodes(NodeState.ACTIVE);
        InternalNode node = nodes.stream().filter(n -> n.getNodeIdentifier().equals(nodeId)).findFirst().orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        Request request = Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri()).appendPath(workerPath).build()).build();
        byte[] responseStream = (byte[])this.httpClient.execute(request, (ResponseHandler)new StreamingJsonResponseHandler());
        return Response.ok((Object)responseStream, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static class StreamingJsonResponseHandler
    implements ResponseHandler<byte[], RuntimeException> {
        private StreamingJsonResponseHandler() {
        }

        public byte[] handleException(Request request, Exception exception) {
            throw new RuntimeException("Request to worker failed", exception);
        }

        public byte[] handle(Request request, io.airlift.http.client.Response response) {
            try {
                if (!"application/json".equals(response.getHeader("Content-Type"))) {
                    throw new RuntimeException("Response received was not of type application/json");
                }
                return ByteStreams.toByteArray((InputStream)response.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read response from worker", e);
            }
        }
    }
}

