/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.RelationPlan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TranslationMap;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.Expression;
import java.util.Map;
import java.util.Objects;

class PlanBuilder {
    private final TranslationMap translations;
    private final PlanNode root;

    public PlanBuilder(TranslationMap translations, PlanNode root) {
        Objects.requireNonNull(translations, "translations is null");
        Objects.requireNonNull(root, "root is null");
        this.translations = translations;
        this.root = root;
    }

    public TranslationMap copyTranslations() {
        TranslationMap translations = new TranslationMap(this.getRelationPlan(), this.getAnalysis(), this.getTranslations().getLambdaDeclarationToSymbolMap());
        translations.copyMappingsFrom(this.getTranslations());
        return translations;
    }

    private Analysis getAnalysis() {
        return this.translations.getAnalysis();
    }

    public PlanBuilder withNewRoot(PlanNode root) {
        return new PlanBuilder(this.translations, root);
    }

    public RelationPlan getRelationPlan() {
        return this.translations.getRelationPlan();
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public boolean canTranslate(Expression expression) {
        return this.translations.containsSymbol(expression);
    }

    public Symbol translate(Expression expression) {
        return this.translations.get(expression);
    }

    public Expression rewrite(Expression expression) {
        return this.translations.rewrite(expression);
    }

    public TranslationMap getTranslations() {
        return this.translations;
    }

    public PlanBuilder appendProjections(Iterable<Expression> expressions, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        TranslationMap translations = this.copyTranslations();
        Assignments.Builder projections = Assignments.builder();
        for (Symbol symbol : this.getRoot().getOutputSymbols()) {
            projections.put(symbol, (Expression)symbol.toSymbolReference());
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Symbol symbol = symbolAllocator.newSymbol(expression, this.getAnalysis().getTypeWithCoercions(expression));
            projections.put(symbol, translations.rewrite(expression));
            newTranslations.put((Object)symbol, (Object)expression);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (Symbol)entry.getKey());
        }
        return new PlanBuilder(translations, new ProjectNode(idAllocator.getNextId(), this.getRoot(), projections.build()));
    }
}

