/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.CostComparator;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.cost.TaskCountEstimator;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.metadata.Metadata;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.SplitManager;
import io.prestosql.sql.planner.OptimizerStatsRecorder;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.iterative.IterativeOptimizer;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.AddExchangesBelowPartialAggregationOverGroupIdRuleSet;
import io.prestosql.sql.planner.iterative.rule.AddIntermediateAggregations;
import io.prestosql.sql.planner.iterative.rule.CanonicalizeExpressions;
import io.prestosql.sql.planner.iterative.rule.CreatePartialTopN;
import io.prestosql.sql.planner.iterative.rule.DesugarArrayConstructor;
import io.prestosql.sql.planner.iterative.rule.DesugarAtTimeZone;
import io.prestosql.sql.planner.iterative.rule.DesugarCurrentPath;
import io.prestosql.sql.planner.iterative.rule.DesugarCurrentUser;
import io.prestosql.sql.planner.iterative.rule.DesugarLambdaExpression;
import io.prestosql.sql.planner.iterative.rule.DesugarLike;
import io.prestosql.sql.planner.iterative.rule.DesugarRowSubscript;
import io.prestosql.sql.planner.iterative.rule.DesugarTryExpression;
import io.prestosql.sql.planner.iterative.rule.DetermineJoinDistributionType;
import io.prestosql.sql.planner.iterative.rule.DetermineSemiJoinDistributionType;
import io.prestosql.sql.planner.iterative.rule.EliminateCrossJoins;
import io.prestosql.sql.planner.iterative.rule.EvaluateZeroSample;
import io.prestosql.sql.planner.iterative.rule.ExtractSpatialJoins;
import io.prestosql.sql.planner.iterative.rule.GatherAndMergeWindows;
import io.prestosql.sql.planner.iterative.rule.ImplementBernoulliSampleAsFilter;
import io.prestosql.sql.planner.iterative.rule.ImplementExceptAsUnion;
import io.prestosql.sql.planner.iterative.rule.ImplementFilteredAggregations;
import io.prestosql.sql.planner.iterative.rule.ImplementIntersectAsUnion;
import io.prestosql.sql.planner.iterative.rule.ImplementLimitWithTies;
import io.prestosql.sql.planner.iterative.rule.ImplementOffset;
import io.prestosql.sql.planner.iterative.rule.InlineProjections;
import io.prestosql.sql.planner.iterative.rule.MergeFilters;
import io.prestosql.sql.planner.iterative.rule.MergeLimitOverProjectWithSort;
import io.prestosql.sql.planner.iterative.rule.MergeLimitWithDistinct;
import io.prestosql.sql.planner.iterative.rule.MergeLimitWithSort;
import io.prestosql.sql.planner.iterative.rule.MergeLimitWithTopN;
import io.prestosql.sql.planner.iterative.rule.MergeLimits;
import io.prestosql.sql.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import io.prestosql.sql.planner.iterative.rule.PruneAggregationColumns;
import io.prestosql.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneApplyColumns;
import io.prestosql.sql.planner.iterative.rule.PruneApplySourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneAssignUniqueIdColumns;
import io.prestosql.sql.planner.iterative.rule.PruneCorrelatedJoinColumns;
import io.prestosql.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import io.prestosql.sql.planner.iterative.rule.PruneDeleteSourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneDistinctLimitSourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneEnforceSingleRowColumns;
import io.prestosql.sql.planner.iterative.rule.PruneExceptSourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneFilterColumns;
import io.prestosql.sql.planner.iterative.rule.PruneIndexSourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneIntersectSourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneJoinChildrenColumns;
import io.prestosql.sql.planner.iterative.rule.PruneJoinColumns;
import io.prestosql.sql.planner.iterative.rule.PruneLimitColumns;
import io.prestosql.sql.planner.iterative.rule.PruneMarkDistinctColumns;
import io.prestosql.sql.planner.iterative.rule.PruneOffsetColumns;
import io.prestosql.sql.planner.iterative.rule.PruneOrderByInAggregation;
import io.prestosql.sql.planner.iterative.rule.PruneOutputColumns;
import io.prestosql.sql.planner.iterative.rule.PruneProjectColumns;
import io.prestosql.sql.planner.iterative.rule.PruneSemiJoinColumns;
import io.prestosql.sql.planner.iterative.rule.PruneSemiJoinFilteringSourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneTableScanColumns;
import io.prestosql.sql.planner.iterative.rule.PruneTopNColumns;
import io.prestosql.sql.planner.iterative.rule.PruneUnionColumns;
import io.prestosql.sql.planner.iterative.rule.PruneUnionSourceColumns;
import io.prestosql.sql.planner.iterative.rule.PruneValuesColumns;
import io.prestosql.sql.planner.iterative.rule.PruneWindowColumns;
import io.prestosql.sql.planner.iterative.rule.PushAggregationThroughOuterJoin;
import io.prestosql.sql.planner.iterative.rule.PushDeleteIntoConnector;
import io.prestosql.sql.planner.iterative.rule.PushLimitIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughMarkDistinct;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughOffset;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughOuterJoin;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughProject;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughSemiJoin;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughUnion;
import io.prestosql.sql.planner.iterative.rule.PushOffsetThroughProject;
import io.prestosql.sql.planner.iterative.rule.PushPartialAggregationThroughExchange;
import io.prestosql.sql.planner.iterative.rule.PushPartialAggregationThroughJoin;
import io.prestosql.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.PushProjectionIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.PushProjectionThroughExchange;
import io.prestosql.sql.planner.iterative.rule.PushProjectionThroughUnion;
import io.prestosql.sql.planner.iterative.rule.PushRemoteExchangeThroughAssignUniqueId;
import io.prestosql.sql.planner.iterative.rule.PushSampleIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.PushTableWriteThroughUnion;
import io.prestosql.sql.planner.iterative.rule.PushTopNThroughOuterJoin;
import io.prestosql.sql.planner.iterative.rule.PushTopNThroughProject;
import io.prestosql.sql.planner.iterative.rule.PushTopNThroughUnion;
import io.prestosql.sql.planner.iterative.rule.RemoveAggregationInSemiJoin;
import io.prestosql.sql.planner.iterative.rule.RemoveDuplicateConditions;
import io.prestosql.sql.planner.iterative.rule.RemoveEmptyDelete;
import io.prestosql.sql.planner.iterative.rule.RemoveFullSample;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantCrossJoin;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantDistinctLimit;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantJoin;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantLimit;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantSort;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantTableScanPredicate;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantTopN;
import io.prestosql.sql.planner.iterative.rule.RemoveTrivialFilters;
import io.prestosql.sql.planner.iterative.rule.RemoveUnreferencedScalarApplyNodes;
import io.prestosql.sql.planner.iterative.rule.RemoveUnreferencedScalarSubqueries;
import io.prestosql.sql.planner.iterative.rule.RemoveUnsupportedDynamicFilters;
import io.prestosql.sql.planner.iterative.rule.ReorderJoins;
import io.prestosql.sql.planner.iterative.rule.RewriteSpatialPartitioningAggregation;
import io.prestosql.sql.planner.iterative.rule.SimplifyCountOverConstant;
import io.prestosql.sql.planner.iterative.rule.SimplifyExpressions;
import io.prestosql.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import io.prestosql.sql.planner.iterative.rule.TransformCorrelatedInPredicateToJoin;
import io.prestosql.sql.planner.iterative.rule.TransformCorrelatedJoinToJoin;
import io.prestosql.sql.planner.iterative.rule.TransformCorrelatedScalarAggregationToJoin;
import io.prestosql.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import io.prestosql.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import io.prestosql.sql.planner.iterative.rule.TransformExistsApplyToCorrelatedJoin;
import io.prestosql.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import io.prestosql.sql.planner.iterative.rule.TransformUncorrelatedSubqueryToJoin;
import io.prestosql.sql.planner.iterative.rule.UnwrapCastInComparison;
import io.prestosql.sql.planner.optimizations.AddExchanges;
import io.prestosql.sql.planner.optimizations.AddLocalExchanges;
import io.prestosql.sql.planner.optimizations.BeginTableWrite;
import io.prestosql.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import io.prestosql.sql.planner.optimizations.HashGenerationOptimizer;
import io.prestosql.sql.planner.optimizations.ImplementIntersectAndExceptAsUnion;
import io.prestosql.sql.planner.optimizations.IndexJoinOptimizer;
import io.prestosql.sql.planner.optimizations.LimitPushDown;
import io.prestosql.sql.planner.optimizations.MetadataQueryOptimizer;
import io.prestosql.sql.planner.optimizations.OptimizeMixedDistinctAggregations;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.optimizations.PredicatePushDown;
import io.prestosql.sql.planner.optimizations.PruneUnreferencedOutputs;
import io.prestosql.sql.planner.optimizations.ReplicateSemiJoinInDelete;
import io.prestosql.sql.planner.optimizations.SetFlatteningOptimizer;
import io.prestosql.sql.planner.optimizations.StatsRecordingPlanOptimizer;
import io.prestosql.sql.planner.optimizations.TableDeleteOptimizer;
import io.prestosql.sql.planner.optimizations.TransformQuantifiedComparisonApplyToCorrelatedJoin;
import io.prestosql.sql.planner.optimizations.UnaliasSymbolReferences;
import io.prestosql.sql.planner.optimizations.WindowFilterPushDown;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExporter;

public class PlanOptimizers {
    private final List<PlanOptimizer> optimizers;
    private final RuleStatsRecorder ruleStats = new RuleStatsRecorder();
    private final OptimizerStatsRecorder optimizerStats = new OptimizerStatsRecorder();
    private final MBeanExporter exporter;

    @Inject
    public PlanOptimizers(Metadata metadata, TypeAnalyzer typeAnalyzer, TaskManagerConfig taskManagerConfig, MBeanExporter exporter, SplitManager splitManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, CostCalculator costCalculator, @CostCalculator.EstimatedExchanges CostCalculator estimatedExchangesCostCalculator, CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this(metadata, typeAnalyzer, taskManagerConfig, false, exporter, splitManager, pageSourceManager, statsCalculator, costCalculator, estimatedExchangesCostCalculator, costComparator, taskCountEstimator);
    }

    @PostConstruct
    public void initialize() {
        this.ruleStats.export(this.exporter);
        this.optimizerStats.export(this.exporter);
    }

    @PreDestroy
    public void destroy() {
        this.ruleStats.unexport(this.exporter);
        this.optimizerStats.unexport(this.exporter);
    }

    public PlanOptimizers(Metadata metadata, TypeAnalyzer typeAnalyzer, TaskManagerConfig taskManagerConfig, boolean forceSingleNode, MBeanExporter exporter, SplitManager splitManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, CostCalculator costCalculator, CostCalculator estimatedExchangesCostCalculator, CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this.exporter = exporter;
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet predicatePushDownRules = ImmutableSet.of((Object)new MergeFilters(metadata));
        ImmutableSet columnPruningRules = ImmutableSet.of((Object)new PruneAggregationColumns(), (Object)new PruneAggregationSourceColumns(), (Object)new PruneApplyColumns(), (Object)new PruneApplySourceColumns(), (Object)new PruneAssignUniqueIdColumns(), (Object)new PruneCorrelatedJoinColumns(), (Object[])new Rule[]{new PruneDeleteSourceColumns(), new PruneDistinctLimitSourceColumns(), new PruneEnforceSingleRowColumns(), new PruneExceptSourceColumns(), new PruneFilterColumns(), new PruneIndexSourceColumns(), new PruneIntersectSourceColumns(), new PruneJoinChildrenColumns(), new PruneJoinColumns(), new PruneMarkDistinctColumns(), new PruneOutputColumns(), new PruneProjectColumns(), new PruneSemiJoinColumns(), new PruneSemiJoinFilteringSourceColumns(), new PruneTopNColumns(), new PruneUnionColumns(), new PruneUnionSourceColumns(), new PruneValuesColumns(), new PruneWindowColumns(), new PruneOffsetColumns(), new PruneLimitColumns(), new PruneTableScanColumns(metadata, typeAnalyzer)});
        ImmutableSet projectionPushdownRules = ImmutableSet.of((Object)new PushProjectionIntoTableScan(metadata, typeAnalyzer), (Object)new PushProjectionThroughUnion(), (Object)new PushProjectionThroughExchange());
        IterativeOptimizer inlineProjections = new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(), (Object)new RemoveRedundantIdentityProjections()));
        IterativeOptimizer projectionPushDown = new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)projectionPushdownRules);
        IterativeOptimizer simplifyOptimizer = new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new SimplifyExpressions(metadata, typeAnalyzer).rules()).addAll(new UnwrapCastInComparison(metadata, typeAnalyzer).rules()).addAll(new RemoveDuplicateConditions(metadata).rules()).addAll(new CanonicalizeExpressions(metadata, typeAnalyzer).rules()).add((Object)new RemoveTrivialFilters()).build());
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new DesugarLambdaExpression().rules()).addAll(new DesugarAtTimeZone(metadata, typeAnalyzer).rules()).addAll(new DesugarCurrentUser(metadata).rules()).addAll(new DesugarCurrentPath(metadata).rules()).addAll(new DesugarTryExpression(metadata, typeAnalyzer).rules()).addAll(new DesugarRowSubscript(typeAnalyzer).rules()).build()), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new CanonicalizeExpressions(metadata, typeAnalyzer).rules()), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)predicatePushDownRules).addAll((Iterable)columnPruningRules).addAll((Iterable)projectionPushdownRules).addAll((Iterable)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new RemoveFullSample(), (Object)new EvaluateZeroSample(), (Object)new PushOffsetThroughProject(), (Object)new PushLimitThroughOffset(), (Object)new PushLimitThroughProject(), (Object[])new Rule[]{new MergeLimits(), new MergeLimitWithSort(), new MergeLimitOverProjectWithSort(), new MergeLimitWithTopN(), new PushLimitThroughMarkDistinct(), new PushLimitThroughOuterJoin(), new PushLimitThroughSemiJoin(), new PushLimitThroughUnion(), new RemoveTrivialFilters(), new RemoveRedundantLimit(), new RemoveRedundantSort(), new RemoveRedundantTopN(), new RemoveRedundantDistinctLimit(), new RemoveRedundantCrossJoin(), new RemoveRedundantJoin(), new ImplementFilteredAggregations(metadata), new SingleDistinctAggregationToGroupBy(), new MultipleDistinctAggregationToMarkDistinct(), new MergeLimitWithDistinct(), new PruneCountAggregationOverScalar(metadata), new PruneOrderByInAggregation(metadata), new RewriteSpatialPartitioningAggregation(metadata)})).build()), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementOffset(), (Object)new ImplementLimitWithTies(metadata))), simplifyOptimizer, new UnaliasSymbolReferences(metadata), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new SetFlatteningOptimizer(), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (List<PlanOptimizer>)ImmutableList.of((Object)new ImplementIntersectAndExceptAsUnion(metadata)), (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementIntersectAsUnion(metadata), (Object)new ImplementExceptAsUnion(metadata))), new LimitPushDown(), new PruneUnreferencedOutputs(metadata, typeAnalyzer), inlineProjections, new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)columnPruningRules), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new TransformExistsApplyToCorrelatedJoin(metadata))), new TransformQuantifiedComparisonApplyToCorrelatedJoin(metadata), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarSubqueries(), (Object)new TransformUncorrelatedSubqueryToJoin(), (Object)new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), (Object)new TransformCorrelatedScalarAggregationToJoin(metadata), (Object)new TransformCorrelatedJoinToJoin(metadata))), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarApplyNodes(), (Object)new TransformCorrelatedInPredicateToJoin(metadata), (Object)new TransformCorrelatedScalarSubquery(metadata), (Object)new TransformCorrelatedJoinToJoin(metadata), (Object)new ImplementFilteredAggregations(metadata))), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(), (Object)new RemoveRedundantIdentityProjections(), (Object)new TransformCorrelatedSingleRowSubqueryToProject(), (Object)new RemoveAggregationInSemiJoin())), new CheckSubqueryNodesAreRewritten(), new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeAnalyzer, false, false)), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)projectionPushdownRules).add((Object)new PushLimitIntoTableScan(metadata)).add((Object)new PushPredicateIntoTableScan(metadata, typeAnalyzer)).add((Object)new PushSampleIntoTableScan(metadata)).build()), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementBernoulliSampleAsFilter(metadata))), new PruneUnreferencedOutputs(metadata, typeAnalyzer), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new PushAggregationThroughOuterJoin(), (Object)new RemoveRedundantCrossJoin())), inlineProjections, simplifyOptimizer, projectionPushDown, new UnaliasSymbolReferences(metadata), new PruneUnreferencedOutputs(metadata, typeAnalyzer), new IndexJoinOptimizer(metadata), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new SimplifyCountOverConstant(metadata))), new LimitPushDown(), new WindowFilterPushDown(metadata), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(GatherAndMergeWindows.rules()).build()), inlineProjections, new PruneUnreferencedOutputs(metadata, typeAnalyzer), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new MetadataQueryOptimizer(metadata), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EliminateCrossJoins(metadata))), new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeAnalyzer, true, false)), simplifyOptimizer, new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushPredicateIntoTableScan(metadata, typeAnalyzer))), projectionPushDown, new PruneUnreferencedOutputs(metadata, typeAnalyzer), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ReorderJoins(metadata, costComparator)))});
        builder.add((Object)new OptimizeMixedDistinctAggregations(metadata));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new CreatePartialTopN(), (Object)new PushTopNThroughProject(), (Object)new PushTopNThroughOuterJoin(), (Object)new PushTopNThroughUnion())));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(new ExtractSpatialJoins(metadata, splitManager, pageSourceManager, typeAnalyzer).rules()).add((Object)new InlineProjections()).build()));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushDeleteIntoConnector(metadata))));
        if (!forceSingleNode) {
            builder.add((Object)new ReplicateSemiJoinInDelete());
            builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new DetermineJoinDistributionType(costComparator, taskCountEstimator), (Object)new DetermineSemiJoinDistributionType(costComparator, taskCountEstimator))));
            builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushTableWriteThroughUnion())));
            builder.add((Object)new UnaliasSymbolReferences(metadata));
            builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new AddExchanges(metadata, typeAnalyzer)));
        }
        estimatedExchangesCostCalculator = null;
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyDelete())));
        builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, typeAnalyzer, true, true)));
        builder.add((Object)new RemoveUnsupportedDynamicFilters(metadata));
        builder.add((Object)simplifyOptimizer);
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantTableScanPredicate(metadata))));
        builder.add((Object)projectionPushDown);
        builder.add((Object)inlineProjections);
        builder.add((Object)new UnaliasSymbolReferences(metadata));
        builder.add((Object)new PruneUnreferencedOutputs(metadata, typeAnalyzer));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).add((Object)new PushRemoteExchangeThroughAssignUniqueId()).add((Object)new InlineProjections()).build()));
        builder.add((Object)new AddLocalExchanges(metadata, typeAnalyzer));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushPartialAggregationThroughJoin(), (Object)new PushPartialAggregationThroughExchange(metadata), (Object)new PruneJoinColumns(), (Object)new PruneJoinChildrenColumns())));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, new AddExchangesBelowPartialAggregationOverGroupIdRuleSet(metadata, typeAnalyzer, taskCountEstimator, taskManagerConfig).rules()));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new AddIntermediateAggregations(), (Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new DesugarLike(metadata, typeAnalyzer).rules()).addAll(new DesugarArrayConstructor(metadata, typeAnalyzer).rules()).build()));
        builder.add((Object)new HashGenerationOptimizer(metadata));
        builder.add((Object)new TableDeleteOptimizer(metadata));
        builder.add((Object)new BeginTableWrite(metadata));
        this.optimizers = builder.build();
    }

    public List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

