/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.planner.iterative.IterativeOptimizer;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.RuleStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.MBeanExport;
import org.weakref.jmx.MBeanExporter;

public class RuleStatsRecorder {
    private final Map<Class<?>, RuleStats> stats = new HashMap();
    @GuardedBy(value="this")
    private final List<MBeanExport> mbeanExports = new ArrayList<MBeanExport>();

    public void registerAll(Collection<Rule<?>> rules) {
        for (Rule<?> rule : rules) {
            Preconditions.checkArgument((!rule.getClass().isAnonymousClass() ? 1 : 0) != 0);
            this.stats.put(rule.getClass(), new RuleStats());
        }
    }

    public void record(Rule<?> rule, long nanos, boolean match) {
        this.stats.get(rule.getClass()).record(nanos, match);
    }

    public void recordFailure(Rule<?> rule) {
        this.stats.get(rule.getClass()).recordFailure();
    }

    synchronized void export(MBeanExporter exporter) {
        Preconditions.checkState((boolean)this.mbeanExports.isEmpty(), (Object)"MBeans already exported");
        for (Map.Entry<Class<?>, RuleStats> entry : this.stats.entrySet()) {
            Verify.verify((!entry.getKey().getSimpleName().isEmpty() ? 1 : 0) != 0);
            try {
                this.mbeanExports.add(exporter.exportWithGeneratedName((Object)entry.getValue(), IterativeOptimizer.class, (Map)ImmutableMap.builder().put((Object)"name", (Object)IterativeOptimizer.class.getSimpleName()).put((Object)"rule", (Object)entry.getKey().getSimpleName()).build()));
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Failed to export MBean with for rule '%s'", entry.getKey().getSimpleName()), e);
            }
        }
    }

    synchronized void unexport(MBeanExporter exporter) {
        for (MBeanExport mbeanExport : this.mbeanExports) {
            mbeanExport.unexport();
        }
        this.mbeanExports.clear();
    }
}

